/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.jetty;

import java.net.URI;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class JettyRequestListener {
    private final AtomicReference<State> state = new AtomicReference<State>(State.CREATED);
    private final URI uri;
    private final long created = System.nanoTime();
    private final AtomicLong requestStarted = new AtomicLong();
    private final AtomicLong requestFinished = new AtomicLong();
    private final AtomicLong responseStarted = new AtomicLong();
    private final AtomicLong responseFinished = new AtomicLong();

    JettyRequestListener(URI uri) {
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    public State getState() {
        return this.state.get();
    }

    public long getCreated() {
        return this.created;
    }

    public long getRequestStarted() {
        return this.requestStarted.get();
    }

    public long getRequestFinished() {
        return this.requestFinished.get();
    }

    public long getResponseStarted() {
        return this.responseStarted.get();
    }

    public long getResponseFinished() {
        return this.responseFinished.get();
    }

    public void onRequestBegin() {
        this.changeState(State.SENDING_REQUEST);
        long now = System.nanoTime();
        this.requestStarted.compareAndSet(0L, now);
    }

    public void onRequestEnd() {
        this.changeState(State.AWAITING_RESPONSE);
        long now = System.nanoTime();
        this.requestStarted.compareAndSet(0L, now);
        this.requestFinished.compareAndSet(0L, now);
    }

    void onResponseBegin() {
        this.changeState(State.READING_RESPONSE);
        long now = System.nanoTime();
        this.requestStarted.compareAndSet(0L, now);
        this.requestFinished.compareAndSet(0L, now);
        this.responseStarted.compareAndSet(0L, now);
    }

    void onFinish() {
        this.changeState(State.FINISHED);
        long now = System.nanoTime();
        this.requestStarted.compareAndSet(0L, now);
        this.requestFinished.compareAndSet(0L, now);
        this.responseStarted.compareAndSet(0L, now);
        this.responseFinished.compareAndSet(0L, now);
    }

    private synchronized void changeState(State newState) {
        if (this.state.get().ordinal() < newState.ordinal()) {
            this.state.set(newState);
        }
    }

    static enum State {
        CREATED,
        SENDING_REQUEST,
        AWAITING_RESPONSE,
        READING_RESPONSE,
        FINISHED;

    }
}

