/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.jetty;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.AbstractFuture;
import com.proofpoint.http.client.HttpClient;
import com.proofpoint.http.client.Request;
import com.proofpoint.http.client.RequestStats;
import com.proofpoint.http.client.ResponseHandler;
import com.proofpoint.http.client.jetty.JettyHttpClient;
import com.proofpoint.http.client.jetty.JettyResponse;
import com.proofpoint.tracetoken.TraceToken;
import com.proofpoint.tracetoken.TraceTokenManager;
import com.proofpoint.tracetoken.TraceTokenScope;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.api.Response;

class JettyResponseFuture<T, E extends Exception>
extends AbstractFuture<T>
implements HttpClient.HttpResponseFuture<T> {
    private JettyHttpClient jettyHttpClient;
    private final long requestStart = System.nanoTime();
    private final AtomicReference<JettyAsyncHttpState> state = new AtomicReference<JettyAsyncHttpState>(JettyAsyncHttpState.WAITING_FOR_CONNECTION);
    private final Request request;
    private final org.eclipse.jetty.client.api.Request jettyRequest;
    private final ResponseHandler<T, E> responseHandler;
    private final AtomicLong bytesWritten;
    private final RequestStats stats;
    private final TraceToken traceToken;

    JettyResponseFuture(JettyHttpClient jettyHttpClient, Request request, org.eclipse.jetty.client.api.Request jettyRequest, ResponseHandler<T, E> responseHandler, AtomicLong bytesWritten, RequestStats stats) {
        this.jettyHttpClient = Objects.requireNonNull(jettyHttpClient, "jettyHttpClientf is null");
        this.request = Objects.requireNonNull(request, "request is null");
        this.jettyRequest = Objects.requireNonNull(jettyRequest, "jettyRequest is null");
        this.responseHandler = Objects.requireNonNull(responseHandler, "responseHandler is null");
        this.bytesWritten = Objects.requireNonNull(bytesWritten, "bytesWritten is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.traceToken = TraceTokenManager.getCurrentTraceToken();
    }

    @Override
    public String getState() {
        return this.state.get().toString();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            this.state.set(JettyAsyncHttpState.CANCELED);
            this.jettyRequest.abort((Throwable)new CancellationException());
            return super.cancel(mayInterruptIfRunning);
        }
        catch (Throwable e) {
            try (TraceTokenScope ignored = TraceTokenManager.registerTraceToken((TraceToken)this.traceToken);){
                this.setException(e);
            }
            return true;
        }
    }

    void completed(Response response, InputStream content) {
        if (this.state.get() == JettyAsyncHttpState.CANCELED) {
            return;
        }
        try (TraceTokenScope ignored = TraceTokenManager.registerTraceToken((TraceToken)this.traceToken);){
            T value;
            try {
                value = this.processResponse(response, content);
            }
            catch (Throwable e) {
                this.storeException(e);
                if (ignored != null) {
                    if (var4_4 != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        ignored.close();
                    }
                }
                return;
            }
            this.state.set(JettyAsyncHttpState.DONE);
            this.set(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T processResponse(Response response, InputStream content) throws E {
        T value;
        long responseStart = System.nanoTime();
        this.state.set(JettyAsyncHttpState.PROCESSING_RESPONSE);
        JettyResponse jettyResponse = null;
        try {
            jettyResponse = new JettyResponse(response, content);
            value = this.responseHandler.handle(this.request, jettyResponse);
        }
        finally {
            JettyHttpClient.recordRequestComplete(this.stats, this.request, this.requestStart, this.bytesWritten.get(), jettyResponse, responseStart);
        }
        return value;
    }

    /*
     * Unable to fully structure code
     */
    void failed(Throwable throwable) {
        if (this.state.get() == JettyAsyncHttpState.CANCELED) {
            return;
        }
        ignored = TraceTokenManager.registerTraceToken((TraceToken)this.traceToken);
        var3_3 = null;
        try {
            if (!(throwable instanceof Exception)) ** GOTO lbl18
            try {
                if (throwable instanceof RejectedExecutionException) {
                    this.jettyHttpClient.maybeLogJettyState();
                }
                value = this.responseHandler.handleException(this.request, (Exception)throwable);
                this.state.set(JettyAsyncHttpState.DONE);
                this.set(value);
                return;
            }
            catch (Throwable newThrowable) {
                try {
                    throwable = newThrowable;
lbl18:
                    // 2 sources

                    this.storeException(throwable);
                }
                catch (Throwable var4_7) {
                    var3_3 = var4_7;
                    throw var4_7;
                }
                catch (Throwable var6_9) {
                    throw var6_9;
                }
            }
        }
        finally {
            if (ignored != null) {
                if (var3_3 != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable var5_8) {
                        var3_3.addSuppressed(var5_8);
                    }
                } else {
                    ignored.close();
                }
            }
        }
    }

    private void storeException(Throwable throwable) {
        if (throwable instanceof CancellationException) {
            this.state.set(JettyAsyncHttpState.CANCELED);
        } else {
            this.state.set(JettyAsyncHttpState.FAILED);
        }
        if (throwable == null) {
            throwable = new Throwable("Throwable is null");
        }
        this.setException(throwable);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("requestStart", this.requestStart).add("state", this.state).add("request", (Object)this.request).toString();
    }

    private static enum JettyAsyncHttpState {
        WAITING_FOR_CONNECTION,
        PROCESSING_RESPONSE,
        DONE,
        FAILED,
        CANCELED;

    }
}

