/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.http.client.testing;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.CountingInputStream;
import com.google.common.net.MediaType;
import com.proofpoint.http.client.HeaderName;
import com.proofpoint.http.client.HttpStatus;
import com.proofpoint.http.client.Response;
import com.proofpoint.json.ObjectMapperProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class TestingResponse
implements Response {
    private final HttpStatus status;
    private final ListMultimap<HeaderName, String> headers;
    private final CountingInputStream countingInputStream;

    private TestingResponse(HttpStatus status, ListMultimap<String, String> headers, byte[] bytes) {
        this(status, headers, new ByteArrayInputStream(Objects.requireNonNull(bytes, "bytes is null")));
    }

    private TestingResponse(HttpStatus status, ListMultimap<String, String> headers, InputStream input) {
        this.status = Objects.requireNonNull(status, "status is null");
        this.headers = ImmutableListMultimap.copyOf(TestingResponse.toHeaderMap(Objects.requireNonNull(headers, "headers is null")));
        this.countingInputStream = new CountingInputStream(Objects.requireNonNull(input, "input is null"));
    }

    @Override
    public int getStatusCode() {
        return this.status.code();
    }

    @Override
    public String getStatusMessage() {
        return this.status.reason();
    }

    @Override
    public ListMultimap<HeaderName, String> getHeaders() {
        return this.headers;
    }

    @Override
    public long getBytesRead() {
        return this.countingInputStream.getCount();
    }

    @Override
    public InputStream getInputStream() {
        return this.countingInputStream;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statusCode", this.getStatusCode()).add("statusMessage", (Object)this.getStatusMessage()).add("headers", this.getHeaders()).toString();
    }

    public static ListMultimap<String, String> contentType(MediaType type) {
        return ImmutableListMultimap.of((Object)"Content-Type", (Object)type.toString());
    }

    public static Response mockResponse(HttpStatus status) {
        return new TestingResponse(status, (ListMultimap<String, String>)ImmutableListMultimap.of(), new byte[0]);
    }

    public static Builder mockResponse() {
        return new Builder();
    }

    private static ListMultimap<HeaderName, String> toHeaderMap(ListMultimap<String, String> headers) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry entry : headers.entries()) {
            builder.put((Object)HeaderName.of((String)entry.getKey()), entry.getValue());
        }
        return builder.build();
    }

    public static class Builder {
        private static final byte[] ZERO_LENGTH_BYTES = new byte[0];
        private HttpStatus status;
        private final ListMultimap<String, String> headers = ArrayListMultimap.create();
        private byte[] bytes;
        private InputStream inputStream;
        private String defaultContentType;

        private Builder() {
        }

        public Builder status(HttpStatus status) {
            Preconditions.checkState((this.status == null ? 1 : 0) != 0, (Object)"status is already set");
            this.status = Objects.requireNonNull(status, "status is null");
            return this;
        }

        public Builder header(String field, String value) {
            this.headers.put((Object)Objects.requireNonNull(field, "field is null"), (Object)Objects.requireNonNull(value, "value is null"));
            return this;
        }

        public Builder headers(ListMultimap<String, String> headers) {
            this.headers.putAll((Multimap)Objects.requireNonNull(headers, "headers is null"));
            return this;
        }

        public Builder contentType(MediaType type) {
            return this.header("Content-Type", type.toString());
        }

        public Builder contentType(String type) {
            return this.header("Content-Type", type);
        }

        public Builder body(byte[] bytes) {
            Objects.requireNonNull(bytes, "bytes is null");
            Preconditions.checkState((this.bytes == null && this.inputStream == null ? 1 : 0) != 0, (Object)"body is already set");
            this.bytes = Arrays.copyOf(bytes, bytes.length);
            return this;
        }

        public Builder body(String content) {
            Objects.requireNonNull(content, "content is null");
            Preconditions.checkState((this.bytes == null && this.inputStream == null ? 1 : 0) != 0, (Object)"body is already set");
            this.bytes = content.getBytes(StandardCharsets.UTF_8);
            return this;
        }

        public Builder body(InputStream inputStream) {
            Preconditions.checkState((this.bytes == null && this.inputStream == null ? 1 : 0) != 0, (Object)"body is already set");
            this.inputStream = Objects.requireNonNull(inputStream, "inputStream is null");
            return this;
        }

        public Builder jsonBody(@Nullable Object entity) {
            Preconditions.checkState((this.bytes == null && this.inputStream == null ? 1 : 0) != 0, (Object)"body is already set");
            this.defaultContentType = "application/json";
            try {
                this.bytes = new ObjectMapperProvider().get().writeValueAsBytes(entity);
            }
            catch (JsonProcessingException e) {
                throw new UncheckedIOException((IOException)((Object)e));
            }
            return this;
        }

        public TestingResponse build() {
            if (this.status == null) {
                this.status = this.bytes == null && this.inputStream == null ? HttpStatus.NO_CONTENT : HttpStatus.OK;
            }
            if (this.defaultContentType != null) {
                boolean haveType = false;
                for (String header : this.headers.keys()) {
                    if (!"content-type".equalsIgnoreCase(header)) continue;
                    haveType = true;
                    break;
                }
                if (!haveType) {
                    this.header("Content-Type", this.defaultContentType);
                }
            }
            if (this.inputStream != null) {
                return new TestingResponse(this.status, this.headers, this.inputStream);
            }
            return new TestingResponse(this.status, this.headers, (byte[])MoreObjects.firstNonNull((Object)this.bytes, (Object)ZERO_LENGTH_BYTES));
        }
    }
}

