/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.proofpoint.http.server.ClientAddressExtractor;
import com.proofpoint.jaxrs.ClientInfo;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;

class ClientInfoSupplier
implements Supplier<ClientInfo> {
    private final ClientAddressExtractor clientAddressExtractor;

    @Inject
    ClientInfoSupplier(ClientAddressExtractor clientAddressExtractor) {
        this.clientAddressExtractor = clientAddressExtractor;
    }

    @Override
    public ClientInfo get() {
        return new InjectedClientInfo(this.clientAddressExtractor);
    }

    private static class InjectedClientInfo
    implements ClientInfo {
        private final ClientAddressExtractor clientAddressExtractor;
        private String address;

        private InjectedClientInfo(ClientAddressExtractor clientAddressExtractor) {
            this.clientAddressExtractor = clientAddressExtractor;
        }

        @Inject
        void setRequest(HttpServletRequest request) {
            this.address = this.clientAddressExtractor.clientAddressFor(request);
        }

        @Override
        public String getAddress() {
            return this.address;
        }
    }
}

