/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.proofpoint.jaxrs.JaxrsConfig;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;

public class HstsResponseFilter
implements ContainerResponseFilter {
    private static final String HSTS = "Strict-Transport-Security";
    private static final String MAX_AGE = "max-age";
    private static final String INCLUDE_SUB_DOMAINS = "; includeSubDomains";
    private static final String PRELOAD = "; preload";
    private final String headerValue;

    @Inject
    public HstsResponseFilter(JaxrsConfig config) {
        Objects.requireNonNull(config, "jaxrsConfig is null");
        if (config.getHstsMaxAge() != null) {
            StringBuilder headerValueBuilder = new StringBuilder(String.format("%s=%d", MAX_AGE, config.getHstsMaxAge().roundTo(TimeUnit.SECONDS)));
            if (config.isIncludeSubDomains()) {
                headerValueBuilder.append(INCLUDE_SUB_DOMAINS);
            }
            if (config.isPreload()) {
                headerValueBuilder.append(PRELOAD);
            }
            this.headerValue = headerValueBuilder.toString();
        } else {
            this.headerValue = null;
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (this.headerValue != null && requestContext.getSecurityContext().isSecure()) {
            responseContext.getHeaders().putSingle((Object)HSTS, (Object)this.headerValue);
        }
    }
}

