/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.proofpoint.jaxrs.AdminJaxrsResource;
import com.proofpoint.jaxrs.JaxrsApplicationPrefixed;
import com.proofpoint.jaxrs.JaxrsBinding;
import com.proofpoint.jaxrs.JaxrsInjectionProvider;
import com.proofpoint.jaxrs.JaxrsResource;
import com.proofpoint.jaxrs.LinkedInjectionProviderBindingBuilder;
import com.proofpoint.jaxrs.PrefixedJaxrsBinder;
import java.util.Objects;
import java.util.function.Supplier;

public class JaxrsBinder {
    private final Binder binder;
    private final Multibinder<Object> resourceBinder;
    private final Multibinder<Object> adminResourceBinder;
    private final Multibinder<JaxrsBinding> keyBinder;
    private final Multibinder<Class<?>> applicationPrefixedBinder;
    private final MapBinder<Class<?>, Supplier<?>> injectionProviderBinder;

    private JaxrsBinder(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder cannot be null").skipSources(new Class[]{this.getClass()});
        this.resourceBinder = Multibinder.newSetBinder((Binder)binder, Object.class, JaxrsResource.class).permitDuplicates();
        this.adminResourceBinder = Multibinder.newSetBinder((Binder)binder, Object.class, AdminJaxrsResource.class).permitDuplicates();
        this.keyBinder = Multibinder.newSetBinder((Binder)binder, JaxrsBinding.class, JaxrsResource.class).permitDuplicates();
        this.applicationPrefixedBinder = Multibinder.newSetBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<?>>(){}, JaxrsApplicationPrefixed.class).permitDuplicates();
        this.injectionProviderBinder = MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<Supplier<?>>(){}, JaxrsInjectionProvider.class);
    }

    public static JaxrsBinder jaxrsBinder(Binder binder) {
        return new JaxrsBinder(binder);
    }

    public PrefixedJaxrsBinder bind(Class<?> implementation) {
        this.binder.bind(implementation).in(Scopes.SINGLETON);
        this.resourceBinder.addBinding().to(implementation).in(Scopes.SINGLETON);
        return this.registerJaxRsBinding(Key.get(implementation));
    }

    public PrefixedJaxrsBinder bindInstance(Object instance) {
        this.resourceBinder.addBinding().toInstance(instance);
        return new PrefixedJaxrsBinder(this.applicationPrefixedBinder, instance.getClass());
    }

    public PrefixedJaxrsBinder bindAdmin(Class<?> implementation) {
        this.binder.bind(implementation).in(Scopes.SINGLETON);
        this.adminResourceBinder.addBinding().to(implementation).in(Scopes.SINGLETON);
        return this.registerJaxRsBinding(Key.get(implementation));
    }

    public PrefixedJaxrsBinder bindAdminInstance(Object instance) {
        this.adminResourceBinder.addBinding().toInstance(instance);
        return new PrefixedJaxrsBinder(this.applicationPrefixedBinder, instance.getClass());
    }

    public PrefixedJaxrsBinder registerJaxRsBinding(Key<?> key) {
        JaxrsBinding binding = new JaxrsBinding(key);
        this.keyBinder.addBinding().toInstance((Object)binding);
        return new PrefixedJaxrsBinder(this.applicationPrefixedBinder, key.getTypeLiteral().getRawType());
    }

    public <T> LinkedInjectionProviderBindingBuilder<T> bindInjectionProvider(Class<T> type) {
        return new LinkedInjectionProviderBindingBuilder<T>(type, this.injectionProviderBinder);
    }
}

