/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.proofpoint.configuration.ConfigBinder;
import com.proofpoint.http.server.TheAdminServlet;
import com.proofpoint.http.server.TheServlet;
import com.proofpoint.jaxrs.AdminJaxrsResource;
import com.proofpoint.jaxrs.ClientInfo;
import com.proofpoint.jaxrs.ClientInfoSupplier;
import com.proofpoint.jaxrs.DisallowOptionsModelProcessor;
import com.proofpoint.jaxrs.HstsResponseFilter;
import com.proofpoint.jaxrs.JaxrsBinder;
import com.proofpoint.jaxrs.JaxrsBinding;
import com.proofpoint.jaxrs.JaxrsConfig;
import com.proofpoint.jaxrs.JaxrsInjectionProvider;
import com.proofpoint.jaxrs.JaxrsResource;
import com.proofpoint.jaxrs.JaxrsTicker;
import com.proofpoint.jaxrs.JsonMapper;
import com.proofpoint.jaxrs.OverrideMethodFilter;
import com.proofpoint.jaxrs.ParsingExceptionMapper;
import com.proofpoint.jaxrs.QueryParamExceptionMapper;
import com.proofpoint.jaxrs.ShutdownMonitor;
import com.proofpoint.jaxrs.SmileMapper;
import com.proofpoint.jaxrs.ThreadDumpResource;
import com.proofpoint.jaxrs.TimingResourceDynamicFeature;
import com.proofpoint.jaxrs.TimingWrapper;
import com.proofpoint.reporting.HealthBinder;
import com.proofpoint.reporting.InRotationResource;
import com.proofpoint.reporting.LivenessResource;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.servlet.Servlet;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerLifecycleListener;
import org.glassfish.jersey.servlet.ServletContainer;

public class JaxrsModule
implements Module {
    private final CommonJaxrsModule commonJaxrsModule = new CommonJaxrsModule();
    private boolean enableOptions = false;

    public static JaxrsModule explicitJaxrsModule() {
        return new JaxrsModule();
    }

    public static Module adminOnlyJaxrsModule() {
        return new AdminOnlyJaxrsModule();
    }

    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.install((Module)this.commonJaxrsModule);
        binder.bind(Servlet.class).annotatedWith(TheServlet.class).to(Key.get(ServletContainer.class));
        JaxrsBinder.jaxrsBinder(binder).bind(JsonMapper.class);
        JaxrsBinder.jaxrsBinder(binder).bind(SmileMapper.class);
        JaxrsBinder.jaxrsBinder(binder).bind(ParsingExceptionMapper.class);
        JaxrsBinder.jaxrsBinder(binder).bind(QueryParamExceptionMapper.class);
        JaxrsBinder.jaxrsBinder(binder).bind(OverrideMethodFilter.class);
        JaxrsBinder.jaxrsBinder(binder).bind(TimingResourceDynamicFeature.class);
        if (!this.enableOptions) {
            JaxrsBinder.jaxrsBinder(binder).bind(DisallowOptionsModelProcessor.class);
        }
        JaxrsBinder.jaxrsBinder(binder).bind(InRotationResource.class);
        JaxrsBinder.jaxrsBinder(binder).bind(LivenessResource.class);
        JaxrsBinder.jaxrsBinder(binder).bind(HstsResponseFilter.class);
        ConfigBinder.bindConfig((Binder)binder).bind(JaxrsConfig.class);
        binder.bind(ShutdownMonitor.class).in(Scopes.SINGLETON);
        HealthBinder.healthBinder((Binder)binder).export(ShutdownMonitor.class);
    }

    @Provides
    ResourceConfig createResourceConfig(Application application, @JaxrsInjectionProvider Map<Class<?>, Supplier<?>> supplierMap, JaxrsConfig jaxrsConfig) {
        return this.commonJaxrsModule.createResourceConfig(application, supplierMap, jaxrsConfig);
    }

    @Provides
    @TheServlet
    static Map<String, String> createTheServletParams() {
        return new HashMap<String, String>();
    }

    private static boolean isJaxRsBinding(Key<?> key) {
        Type type = key.getTypeLiteral().getType();
        if (!(type instanceof Class)) {
            return false;
        }
        return JaxrsModule.isJaxRsType((Class)type);
    }

    private static boolean isJaxRsType(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (type.isAnnotationPresent(Provider.class)) {
            return true;
        }
        if (type.isAnnotationPresent(Path.class)) {
            return true;
        }
        if (JaxrsModule.isJaxRsType(type.getSuperclass())) {
            return true;
        }
        for (Class<?> typeInterface : type.getInterfaces()) {
            if (!JaxrsModule.isJaxRsType(typeInterface)) continue;
            return true;
        }
        return false;
    }

    public JaxrsModule withOptionsEnabled() {
        this.enableOptions = true;
        return this;
    }

    private static class CommonJaxrsModule
    implements Module {
        private final AtomicReference<InjectionManager> injectionManagerReference = new AtomicReference();

        private CommonJaxrsModule() {
        }

        public void configure(Binder binder) {
            binder.disableCircularProxies();
            JaxrsBinder.jaxrsBinder(binder).bindInjectionProvider(ClientInfo.class).to(ClientInfoSupplier.class);
            JaxrsBinder.jaxrsBinder(binder).bindAdmin(ParsingExceptionMapper.class);
            JaxrsBinder.jaxrsBinder(binder).bindAdmin(QueryParamExceptionMapper.class);
            JaxrsBinder.jaxrsBinder(binder).bindAdmin(OverrideMethodFilter.class);
            JaxrsBinder.jaxrsBinder(binder).bindAdmin(ThreadDumpResource.class);
            Multibinder.newSetBinder((Binder)binder, Object.class, JaxrsResource.class).permitDuplicates();
            Multibinder.newSetBinder((Binder)binder, JaxrsBinding.class, JaxrsResource.class).permitDuplicates();
            MapBinder.newMapBinder((Binder)binder, (TypeLiteral)new TypeLiteral<Class<?>>(){}, (TypeLiteral)new TypeLiteral<Supplier<?>>(){}, JaxrsInjectionProvider.class);
        }

        @Provides
        static ServletContainer createServletContainer(ResourceConfig resourceConfig) {
            return new ServletContainer(resourceConfig);
        }

        ResourceConfig createResourceConfig(Application application, final @JaxrsInjectionProvider Map<Class<?>, Supplier<?>> supplierMap, JaxrsConfig jaxrsConfig) {
            ResourceConfig config = ResourceConfig.forApplication((Application)application);
            config.setProperties((Map)ImmutableMap.builder().put((Object)"jersey.config.server.wadl.disableWadl", (Object)"true").put((Object)"jersey.config.server.headers.location.relative.resolution.disabled", (Object)"true").put((Object)"jersey.config.servlet.form.queryParams.disabled", (Object)"true").build());
            config.register(MultiPartFeature.class);
            config.register((Object)new ContainerLifecycleListener(){

                public void onStartup(Container container) {
                    InjectionManager injectionManager = container.getApplicationHandler().getInjectionManager();
                    injectionManagerReference.set(injectionManager);
                }

                public void onReload(Container container) {
                }

                public void onShutdown(Container container) {
                }
            });
            config.register((Object)new AbstractBinder(){

                protected void configure() {
                    for (Map.Entry entry : supplierMap.entrySet()) {
                        this.bindSupplier((Class)entry.getKey(), (Supplier)entry.getValue());
                    }
                }

                private <T> void bindSupplier(Class<T> type, Supplier<?> supplier) {
                    this.bindFactory(new InjectionProviderFactory<T>(type, supplier, injectionManagerReference)).to(type);
                }
            });
            return config;
        }

        @Provides
        Application createJaxRsApplication(@JaxrsResource Set<Object> jaxRsSingletons, @JaxrsResource Set<JaxrsBinding> jaxrsBinding, Injector injector) {
            HashSet<Key> missingBindings = new HashSet<Key>();
            ImmutableSet.Builder singletons = ImmutableSet.builder();
            jaxRsSingletons.stream().map(TimingWrapper::wrapIfAnnotatedResource).forEach(arg_0 -> ((ImmutableSet.Builder)singletons).add(arg_0));
            while (injector != null) {
                for (Map.Entry entry : injector.getBindings().entrySet()) {
                    Key key = (Key)entry.getKey();
                    if (!JaxrsModule.isJaxRsBinding(key) || jaxrsBinding.contains(new JaxrsBinding(key))) continue;
                    missingBindings.add(key);
                }
                injector = injector.getParent();
            }
            Preconditions.checkState((boolean)missingBindings.isEmpty(), (String)"Jax-rs services must be explicitly bound using the JaxRsBinder: ", missingBindings);
            return new JaxRsApplication((Set<Object>)singletons.build());
        }

        @Provides
        @TheAdminServlet
        static Servlet createTheAdminServlet(@AdminJaxrsResource Set<Object> adminJaxRsSingletons, ObjectMapper objectMapper) {
            ImmutableSet.Builder singletons = ImmutableSet.builder();
            singletons.addAll(adminJaxRsSingletons);
            singletons.add((Object)new JsonMapper(objectMapper));
            JaxRsApplication application = new JaxRsApplication((Set<Object>)singletons.build());
            return new ServletContainer(ResourceConfig.forApplication((Application)application));
        }

        @Provides
        @TheAdminServlet
        static Map<String, String> createTheAdminServletParams() {
            return new HashMap<String, String>();
        }

        @Provides
        @JaxrsTicker
        static Ticker createTicker() {
            return Ticker.systemTicker();
        }

        private static class InjectionProviderFactory<T>
        implements Factory<T> {
            private final Supplier<? extends T> supplier;
            private final AtomicReference<InjectionManager> injectionManagerReference;

            InjectionProviderFactory(Class<T> type, Supplier<? extends T> supplier, AtomicReference<InjectionManager> injectionManagerReference) {
                this.supplier = supplier;
                this.injectionManagerReference = injectionManagerReference;
            }

            public T provide() {
                T object = this.supplier.get();
                InjectionManager injectionManager = this.injectionManagerReference.get();
                injectionManager.inject(object);
                return object;
            }

            public void dispose(T o) {
                this.injectionManagerReference.get().preDestroy(o);
            }
        }

        private static class JaxRsApplication
        extends Application {
            private final Set<Object> jaxRsSingletons;

            JaxRsApplication(Set<Object> jaxRsSingletons) {
                this.jaxRsSingletons = ImmutableSet.copyOf(jaxRsSingletons);
            }

            public Set<Object> getSingletons() {
                return this.jaxRsSingletons;
            }
        }
    }

    private static class AdminOnlyJaxrsModule
    implements Module {
        private final CommonJaxrsModule commonJaxrsModule = new CommonJaxrsModule();

        private AdminOnlyJaxrsModule() {
        }

        public void configure(Binder binder) {
            binder.install((Module)this.commonJaxrsModule);
        }

        @Provides
        ResourceConfig createResourceConfig(Application application, @JaxrsInjectionProvider Map<Class<?>, Supplier<?>> supplierMap) {
            return this.commonJaxrsModule.createResourceConfig(application, supplierMap, new JaxrsConfig());
        }
    }
}

