/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.collect.ImmutableSet;
import com.proofpoint.jaxrs.JsonMapperParsingException;
import com.proofpoint.jaxrs.ValidationUtils;
import com.proofpoint.log.Logger;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/json", "text/json"})
@Produces(value={"application/json", "text/json"})
public class JsonMapper
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final ImmutableSet<Class<?>> IO_CLASSES = ImmutableSet.builder().add(InputStream.class).add(Reader.class).add(OutputStream.class).add(Writer.class).add(byte[].class).add(char[].class).add(StreamingOutput.class).add(Response.class).build();
    public static final Logger log = Logger.get(JsonMapper.class);
    private final ObjectMapper objectMapper;
    private final AtomicReference<UriInfo> uriInfo = new AtomicReference();

    @Inject
    public JsonMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Context
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo.set(uriInfo);
    }

    private UriInfo getUriInfo() {
        return this.uriInfo.get();
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonMapper.canReadOrWrite(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonMapper.canReadOrWrite(type);
    }

    private static boolean canReadOrWrite(Class<?> type) {
        if (IO_CLASSES.contains(type)) {
            return false;
        }
        for (Class ioClass : IO_CLASSES) {
            if (!ioClass.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException {
        Object object;
        try {
            JsonParser jsonParser = this.objectMapper.getFactory().createParser(inputStream);
            jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            object = this.objectMapper.readValue(jsonParser, this.objectMapper.getTypeFactory().constructType(genericType));
        }
        catch (Exception e) {
            if (e instanceof IOException && !(e instanceof JsonProcessingException) && !(e instanceof EOFException)) {
                throw e;
            }
            log.info("Invalid json for Java type %s: %s", new Object[]{type, e.getMessage()});
            throw JsonMapperParsingException.jsonMapperParsingException(type, e);
        }
        ValidationUtils.validateObject(genericType, object);
        return object;
    }

    public long getSize(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        httpHeaders.add((Object)"X-Content-Type-Options", (Object)"nosniff");
        JsonFactory jsonFactory = this.objectMapper.getFactory();
        jsonFactory.setCharacterEscapes((CharacterEscapes)HTMLCharacterEscapes.INSTANCE);
        JsonGenerator jsonGenerator = jsonFactory.createGenerator(outputStream, JsonEncoding.UTF8);
        jsonGenerator.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        if (this.isPrettyPrintRequested()) {
            jsonGenerator.useDefaultPrettyPrinter();
        }
        JavaType rootType = null;
        if (genericType != null && value != null && genericType.getClass() != Class.class && (rootType = this.objectMapper.getTypeFactory().constructType(genericType)).getRawClass() == Object.class) {
            rootType = null;
        }
        ObjectWriter writer = rootType != null ? this.objectMapper.writerFor(rootType) : this.objectMapper.writer();
        writer.writeValue(jsonGenerator, value);
        outputStream.write(10);
    }

    private boolean isPrettyPrintRequested() {
        UriInfo uriInfo = this.getUriInfo();
        if (uriInfo == null) {
            return false;
        }
        MultivaluedMap queryParameters = uriInfo.getQueryParameters();
        return queryParameters.containsKey((Object)"pretty");
    }

    private static class HTMLCharacterEscapes
    extends CharacterEscapes {
        private static final HTMLCharacterEscapes INSTANCE = new HTMLCharacterEscapes();
        private final int[] asciiEscapes;

        private HTMLCharacterEscapes() {
            int[] esc = CharacterEscapes.standardAsciiEscapesForJSON();
            esc[60] = -1;
            esc[62] = -1;
            esc[38] = -1;
            esc[39] = -1;
            this.asciiEscapes = esc;
        }

        public int[] getEscapeCodesForAscii() {
            return this.asciiEscapes;
        }

        public SerializableString getEscapeSequence(int ch) {
            return null;
        }
    }
}

