/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.proofpoint.jaxrs.ParsingException;

public class JsonMapperParsingException
extends ParsingException {
    private final Class<?> type;

    private JsonMapperParsingException(Class<?> type, String message, Throwable cause) {
        super(message, cause);
        this.type = type;
    }

    static JsonMapperParsingException jsonMapperParsingException(Class<?> type, Throwable cause) {
        StringBuilder sb = new StringBuilder("Invalid json");
        JsonLocation location = null;
        if (cause instanceof JsonProcessingException) {
            location = ((JsonProcessingException)cause).getLocation();
        }
        if (location != null) {
            sb.append(" line ").append(location.getLineNr()).append(" column ").append(location.getColumnNr());
        }
        if (cause instanceof JsonMappingException) {
            sb.append(" field ");
            boolean appendDot = false;
            for (JsonMappingException.Reference reference : ((JsonMappingException)cause).getPath()) {
                if (appendDot) {
                    sb.append('.');
                }
                appendDot = true;
                if (reference.getIndex() >= 0) {
                    sb.append('[');
                    sb.append(reference.getIndex());
                    sb.append(']');
                    continue;
                }
                if (reference.getFieldName() != null) {
                    sb.append(reference.getFieldName());
                    continue;
                }
                sb.append('?');
            }
            if (!appendDot) {
                sb.append('?');
            }
        }
        return new JsonMapperParsingException(type, sb.toString(), cause);
    }

    public Class<?> getType() {
        return this.type;
    }
}

