/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import java.util.function.Supplier;
import javax.inject.Provider;

public class LinkedInjectionProviderBindingBuilder<T> {
    private final Class<T> type;
    private final MapBinder<Class<?>, Supplier<?>> injectionProviderBinder;

    LinkedInjectionProviderBindingBuilder(Class<T> type, MapBinder<Class<?>, Supplier<?>> injectionProviderBinder) {
        this.type = type;
        this.injectionProviderBinder = injectionProviderBinder;
    }

    public void to(Class<? extends Supplier<? extends T>> implementation) {
        this.injectionProviderBinder.addBinding(this.type).to(implementation).in(Scopes.SINGLETON);
    }

    public void to(TypeLiteral<? extends Supplier<? extends T>> implementation) {
        this.injectionProviderBinder.addBinding(this.type).to(implementation).in(Scopes.SINGLETON);
    }

    public void to(Key<? extends Supplier<? extends T>> targetKey) {
        this.injectionProviderBinder.addBinding(this.type).to(targetKey).in(Scopes.SINGLETON);
    }

    public void toInstance(Supplier<? extends T> supplier) {
        this.injectionProviderBinder.addBinding(this.type).toInstance(supplier);
    }

    public void toProvider(Provider<? extends Supplier<? extends T>> provider) {
        this.injectionProviderBinder.addBinding(this.type).toProvider(provider).in(Scopes.SINGLETON);
    }

    public void toProvider(Class<? extends Provider<? extends Supplier<? extends T>>> providerType) {
        this.injectionProviderBinder.addBinding(this.type).toProvider(providerType).in(Scopes.SINGLETON);
    }

    public void toProvider(TypeLiteral<? extends Provider<? extends Supplier<? extends T>>> providerType) {
        this.injectionProviderBinder.addBinding(this.type).toProvider(providerType).in(Scopes.SINGLETON);
    }

    public void toProvider(Key<? extends Provider<? extends Supplier<? extends T>>> providerKey) {
        this.injectionProviderBinder.addBinding(this.type).toProvider(providerKey).in(Scopes.SINGLETON);
    }
}

