/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.google.common.base.Strings;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;

@Provider
@PreMatching
public class OverrideMethodFilter
implements ContainerRequestFilter {
    public static final String HEADER = "X-HTTP-Method-Override";
    public static final String METHOD_PARAM = "_method";

    public void filter(ContainerRequestContext request) {
        String method = (String)request.getHeaders().getFirst((Object)HEADER);
        if (Strings.isNullOrEmpty((String)method)) {
            method = (String)request.getUriInfo().getQueryParameters().getFirst((Object)METHOD_PARAM);
        }
        if (!Strings.isNullOrEmpty((String)method)) {
            if (request.getMethod().equalsIgnoreCase("POST")) {
                request.setMethod(method);
            } else {
                throw new WebApplicationException(Response.Status.BAD_REQUEST);
            }
        }
    }
}

