/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.proofpoint.bootstrap.QuietMode;
import com.proofpoint.bootstrap.StopTraffic;
import com.proofpoint.jaxrs.AccessDoesNotRequireAuthentication;
import com.proofpoint.log.Logger;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/admin/jstack")
@AccessDoesNotRequireAuthentication
public class ThreadDumpResource {
    private static final Logger log = Logger.get(ThreadDumpResource.class);
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private final boolean quiet;

    @Inject
    public ThreadDumpResource(@QuietMode boolean quiet) {
        this.quiet = quiet;
    }

    @GET
    @Produces(value={"text/plain"})
    public String get() {
        StringBuilder sb = new StringBuilder();
        long[] deadlockedThreads = THREAD_MX_BEAN.findDeadlockedThreads();
        if (deadlockedThreads != null) {
            sb.append("Deadlock found:\n");
            for (ThreadInfo threadInfo : THREAD_MX_BEAN.getThreadInfo(deadlockedThreads, true, true)) {
                ThreadDumpResource.appendThreadInfo(sb, threadInfo);
            }
            sb.append("\nFull list of threads:\n");
        }
        for (ThreadInfo threadInfo : THREAD_MX_BEAN.getThreadInfo(THREAD_MX_BEAN.getAllThreadIds(), true, true)) {
            ThreadDumpResource.appendThreadInfo(sb, threadInfo);
        }
        return sb.toString();
    }

    private static void appendThreadInfo(StringBuilder sb, ThreadInfo threadInfo) {
        sb.append('\"').append(threadInfo.getThreadName()).append("\" #").append(threadInfo.getThreadId());
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (running in native)");
        }
        sb.append("\n   state: ").append((Object)threadInfo.getThreadState());
        String lockName = threadInfo.getLockName();
        if (lockName != null) {
            sb.append(" on ").append(lockName);
            String lockOwnerName = threadInfo.getLockOwnerName();
            if (lockOwnerName != null) {
                sb.append(" owned by ").append(threadInfo.getLockOwnerId()).append(" (").append(lockOwnerName).append(")");
            }
        }
        StackTraceElement[] stackTrace = threadInfo.getStackTrace();
        MonitorInfo[] monitors = threadInfo.getLockedMonitors();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            sb.append("\n\tat ").append(element);
            MonitorInfo[] monitorInfoArray = monitors;
            int n = monitorInfoArray.length;
            for (int j = 0; j < n; ++j) {
                MonitorInfo monitor = monitorInfoArray[j];
                if (monitor.getLockedStackDepth() != i) continue;
                sb.append("\n\t  - locked ").append(monitor);
            }
        }
        LockInfo[] lockedSynchronizers = threadInfo.getLockedSynchronizers();
        if (lockedSynchronizers.length != 0) {
            sb.append("\n\tLocked synchronizers:");
            for (LockInfo lockedSynchronizer : lockedSynchronizers) {
                sb.append("\n\t  - ").append(lockedSynchronizer);
            }
        }
        sb.append("\n\n");
    }

    @StopTraffic
    public void logThreadDump() {
        if (!this.quiet) {
            log.info("Thread dump at shutdown:\n%s", new Object[]{this.get()});
        }
    }
}

