/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.google.common.base.Ticker;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.proofpoint.stats.SparseTimeStat;
import com.proofpoint.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;

@Priority(value=100)
class TimingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    static final String TAGS_KEY = TimingFilter.class.getName() + ".tags";
    private static final String START_TIME_KEY = TimingFilter.class.getName() + ".start-time";
    private final String methodName;
    private final LoadingCache<List<Optional<String>>, SparseTimeStat> loadingCache;
    private final Ticker ticker;

    TimingFilter(String methodName, LoadingCache<List<Optional<String>>, SparseTimeStat> loadingCache, Ticker ticker) {
        this.methodName = Objects.requireNonNull(methodName, "methodName is null");
        this.loadingCache = Objects.requireNonNull(loadingCache, "loadingCache is null");
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
    }

    public void filter(ContainerRequestContext request) {
        request.setProperty(START_TIME_KEY, (Object)this.ticker.read());
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        Long startTime = (Long)request.getProperty(START_TIME_KEY);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new Optional[]{Optional.of(this.methodName), Optional.of(Integer.toString(response.getStatus())), Optional.of(Integer.toString(response.getStatus() / 100))});
        Collection tags = (Collection)request.getProperty(TAGS_KEY);
        if (tags != null) {
            for (Optional tag : tags) {
                builder.add(tag.map(Object::toString));
            }
        }
        ((SparseTimeStat)this.loadingCache.getUnchecked((Object)builder.build())).add(Duration.succinctNanos((long)(this.ticker.read() - startTime)));
    }
}

