/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.proofpoint.jaxrs.JaxrsApplicationPrefixed;
import com.proofpoint.jaxrs.JaxrsTicker;
import com.proofpoint.jaxrs.TimingFilter;
import com.proofpoint.jaxrs.TimingWrapped;
import com.proofpoint.reporting.ReportExporter;
import com.proofpoint.stats.SparseTimeStat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import javax.ws.rs.Path;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

@Provider
class TimingResourceDynamicFeature
implements DynamicFeature {
    private final Set<Class<?>> applicationPrefixedClasses;
    private final ReportExporter reportExporter;
    private final Ticker ticker;

    @Inject
    public TimingResourceDynamicFeature(ReportExporter reportExporter, @JaxrsApplicationPrefixed Set<Class<?>> applicationPrefixedClasses, @JaxrsTicker Ticker ticker) {
        this.reportExporter = Objects.requireNonNull(reportExporter, "reportExporter is null");
        this.applicationPrefixedClasses = Objects.requireNonNull(applicationPrefixedClasses, "applicationPrefixedClasses is null");
        this.ticker = Objects.requireNonNull(ticker, "ticker is null");
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext featureContext) {
        Class<?> resourceClass = resourceInfo.getResourceClass();
        Method resourceMethod = resourceInfo.getResourceMethod();
        if (resourceClass == null || resourceMethod == null) {
            return;
        }
        if (!TimingResourceDynamicFeature.isJaxRsResource(resourceClass)) {
            return;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])new String[]{"method", "responseCode", "responseCodeFamily"});
        if (TimingWrapped.class.isAssignableFrom(resourceClass)) {
            Map keyNamesMap;
            try {
                keyNamesMap = (Map)resourceClass.getDeclaredMethod("getKeyNames", new Class[0]).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            List keyNames = (List)keyNamesMap.get(resourceMethod.getName());
            if (keyNames != null) {
                builder.addAll((Iterable)keyNames);
            }
            try {
                resourceClass = resourceClass.getDeclaredField("delegate").getType();
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
        LoadingCache<List<Optional<String>>, SparseTimeStat> loadingCache = new CacheImplementation(this.applicationPrefixedClasses.contains(resourceClass), resourceClass.getSimpleName() + ".RequestTime", (List<String>)builder.build()).getLoadingCache();
        featureContext.register((Object)new TimingFilter(resourceMethod.getName(), loadingCache, this.ticker));
    }

    private static boolean isJaxRsResource(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (type.isAnnotationPresent(Path.class)) {
            return true;
        }
        if (TimingResourceDynamicFeature.isJaxRsResource(type.getSuperclass())) {
            return true;
        }
        for (Class<?> typeInterface : type.getInterfaces()) {
            if (!TimingResourceDynamicFeature.isJaxRsResource(typeInterface)) continue;
            return true;
        }
        return false;
    }

    private class CacheImplementation {
        private final LoadingCache<List<Optional<String>>, SparseTimeStat> loadingCache;
        @GuardedBy(value="registeredMap")
        private final Map<List<Optional<String>>, SparseTimeStat> registeredMap = new HashMap<List<Optional<String>>, SparseTimeStat>();
        @GuardedBy(value="registeredMap")
        private final Set<SparseTimeStat> reinsertedSet = new HashSet<SparseTimeStat>();

        CacheImplementation(final boolean applicationPrefix, final String namePrefix, final List<String> keyNames) {
            this.loadingCache = CacheBuilder.newBuilder().ticker(TimingResourceDynamicFeature.this.ticker).expireAfterAccess(15L, TimeUnit.MINUTES).removalListener((RemovalListener)new UnexportRemovalListener()).build((CacheLoader)new CacheLoader<List<Optional<String>>, SparseTimeStat>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public SparseTimeStat load(List<Optional<String>> key) {
                    SparseTimeStat returnValue = new SparseTimeStat();
                    Map map = CacheImplementation.this.registeredMap;
                    synchronized (map) {
                        SparseTimeStat existingStat = (SparseTimeStat)CacheImplementation.this.registeredMap.get(key);
                        if (existingStat != null) {
                            CacheImplementation.this.reinsertedSet.add(existingStat);
                            return existingStat;
                        }
                        CacheImplementation.this.registeredMap.put(key, returnValue);
                        ImmutableMap.Builder tagBuilder = ImmutableMap.builder();
                        for (int i = 0; i < keyNames.size(); ++i) {
                            Optional<String> keyValue = key.get(i);
                            if (!keyValue.isPresent()) continue;
                            tagBuilder.put(keyNames.get(i), (Object)keyValue.get());
                        }
                        TimingResourceDynamicFeature.this.reportExporter.export((Object)returnValue, applicationPrefix, namePrefix, (Map)tagBuilder.build());
                    }
                    return returnValue;
                }
            });
        }

        LoadingCache<List<Optional<String>>, SparseTimeStat> getLoadingCache() {
            return this.loadingCache;
        }

        private class UnexportRemovalListener
        implements RemovalListener<List<Optional<String>>, SparseTimeStat> {
            private UnexportRemovalListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRemoval(RemovalNotification<List<Optional<String>>, SparseTimeStat> notification) {
                Map map = CacheImplementation.this.registeredMap;
                synchronized (map) {
                    if (CacheImplementation.this.reinsertedSet.remove(notification.getValue())) {
                        return;
                    }
                    TimingResourceDynamicFeature.this.reportExporter.unexportObject(notification.getValue());
                    CacheImplementation.this.registeredMap.remove(notification.getKey());
                }
            }
        }
    }
}

