/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.TypeLiteral;
import com.proofpoint.jaxrs.TimingFilter;
import com.proofpoint.jaxrs.TimingWrapped;
import com.proofpoint.jaxrs.internal.bytebuddy.ByteBuddy;
import com.proofpoint.jaxrs.internal.bytebuddy.description.field.FieldDescription;
import com.proofpoint.jaxrs.internal.bytebuddy.description.field.FieldList;
import com.proofpoint.jaxrs.internal.bytebuddy.description.method.MethodDescription;
import com.proofpoint.jaxrs.internal.bytebuddy.description.method.MethodList;
import com.proofpoint.jaxrs.internal.bytebuddy.description.method.ParameterDescription;
import com.proofpoint.jaxrs.internal.bytebuddy.description.modifier.FieldManifestation;
import com.proofpoint.jaxrs.internal.bytebuddy.description.modifier.ModifierContributor;
import com.proofpoint.jaxrs.internal.bytebuddy.description.modifier.Ownership;
import com.proofpoint.jaxrs.internal.bytebuddy.description.modifier.Visibility;
import com.proofpoint.jaxrs.internal.bytebuddy.description.type.TypeDescription;
import com.proofpoint.jaxrs.internal.bytebuddy.dynamic.DynamicType;
import com.proofpoint.jaxrs.internal.bytebuddy.dynamic.loading.ClassInjector;
import com.proofpoint.jaxrs.internal.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import com.proofpoint.jaxrs.internal.bytebuddy.dynamic.scaffold.InstrumentedType;
import com.proofpoint.jaxrs.internal.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import com.proofpoint.jaxrs.internal.bytebuddy.implementation.FieldAccessor;
import com.proofpoint.jaxrs.internal.bytebuddy.implementation.FixedValue;
import com.proofpoint.jaxrs.internal.bytebuddy.implementation.Implementation;
import com.proofpoint.jaxrs.internal.bytebuddy.implementation.MethodCall;
import com.proofpoint.jaxrs.internal.bytebuddy.implementation.bytecode.ByteCodeAppender;
import com.proofpoint.jaxrs.internal.bytebuddy.implementation.bytecode.StackManipulation;
import com.proofpoint.jaxrs.internal.bytebuddy.implementation.bytecode.member.FieldAccess;
import com.proofpoint.jaxrs.internal.bytebuddy.implementation.bytecode.member.MethodInvocation;
import com.proofpoint.jaxrs.internal.bytebuddy.implementation.bytecode.member.MethodReturn;
import com.proofpoint.jaxrs.internal.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import com.proofpoint.jaxrs.internal.bytebuddy.matcher.ElementMatchers;
import com.proofpoint.reporting.Key;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;

class TimingWrapper {
    private static final ImmutableSet<Class<?>> JAXRS_ANNOTATIONS = ImmutableSet.of(GET.class, PUT.class, POST.class, DELETE.class, HEAD.class);
    private static final Type KEYNAMES_MAP_TYPE = new TypeLiteral<Map<String, List<String>>>(){}.getType();

    private TimingWrapper() {
    }

    static Object wrapIfAnnotatedResource(Object jaxRsSingleton) {
        Class<?> jaxRsSingletonClass = jaxRsSingleton.getClass();
        if (!jaxRsSingletonClass.isAnnotationPresent(Path.class)) {
            return jaxRsSingleton;
        }
        boolean hasKeyAnnotation = false;
        ImmutableMap.Builder keyNamesBuilder = ImmutableMap.builder();
        DynamicType.Builder.MethodDefinition<Object> typeDefinition = new ByteBuddy().subclass(TimingWrapped.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).annotateType(jaxRsSingletonClass.getAnnotations()).defineField("delegate", jaxRsSingletonClass, Visibility.PRIVATE, FieldManifestation.FINAL).defineConstructor(Visibility.PACKAGE_PRIVATE).withParameters(jaxRsSingletonClass).intercept(MethodCall.invoke((MethodDescription)((MethodList)new TypeDescription.ForLoadedType(TimingWrapped.class).getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly()).onSuper().andThen(FieldAccessor.ofField("delegate").setsArgumentAt(0)));
        for (Method method : jaxRsSingletonClass.getMethods()) {
            ArrayList<String> keyNames = new ArrayList<String>();
            if (!Arrays.stream(method.getAnnotations()).anyMatch(annotation -> JAXRS_ANNOTATIONS.contains(annotation.annotationType()))) continue;
            DynamicType.Builder.MethodDefinition.ParameterDefinition<Object> defineMethod = typeDefinition.defineMethod(method.getName(), method.getReturnType(), method.getModifiers());
            for (Parameter parameter : method.getParameters()) {
                DynamicType.Builder.MethodDefinition.ParameterDefinition.Annotatable defineParameter = defineMethod.withParameter(parameter.getType(), parameter.getName(), parameter.getModifiers()).annotateParameter(parameter.getAnnotations());
                defineMethod = defineParameter;
                Key keyAnnotation = parameter.getAnnotation(Key.class);
                if (keyAnnotation == null) continue;
                String keyValue = keyAnnotation.value();
                if ("method".equals(keyValue) || "responseCode".equals(keyValue) || "responseCodeFamily".equals(keyValue)) {
                    throw new RuntimeException("\"" + keyValue + "\" tag name in @Key annotation on parameter of method " + method + " duplicates standard tag name");
                }
                if (keyNames.contains(keyValue)) {
                    throw new RuntimeException("Duplicate \"" + keyValue + "\" tag name in @Key annotation on parameter of method " + method);
                }
                keyNames.add(keyValue);
            }
            if (!keyNames.isEmpty()) {
                hasKeyAnnotation = true;
                keyNamesBuilder.put((Object)method.getName(), keyNames);
                defineMethod = defineMethod.withParameter((Type)((Object)ContainerRequestContext.class), "timingWrapperContext", new ModifierContributor.ForParameter[0]).annotateParameter(new Annotation[]{new Context(){

                    public Class<? extends Annotation> annotationType() {
                        return Context.class;
                    }
                }});
            }
            typeDefinition = defineMethod.intercept(new MethodImplementation(method, !keyNames.isEmpty())).annotateMethod(method.getAnnotations());
        }
        if (!hasKeyAnnotation) {
            return jaxRsSingleton;
        }
        try {
            ClassLoadingStrategy<ClassLoader> strategy;
            if (ClassInjector.UsingLookup.isAvailable()) {
                Class<?> methodHandles = Class.forName("java.lang.invoke.MethodHandles");
                Object lookup = methodHandles.getMethod("lookup", new Class[0]).invoke(null, new Object[0]);
                Method privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, Class.forName("java.lang.invoke.MethodHandles$Lookup"));
                Object privateLookup = privateLookupIn.invoke(null, TimingWrapper.class, lookup);
                strategy = ClassLoadingStrategy.UsingLookup.of(privateLookup);
            } else if (ClassInjector.UsingReflection.isAvailable()) {
                strategy = ClassLoadingStrategy.Default.INJECTION;
            } else {
                throw new IllegalStateException("No code generation strategy available");
            }
            return typeDefinition.defineMethod("getKeyNames", KEYNAMES_MAP_TYPE, Ownership.STATIC, Visibility.PACKAGE_PRIVATE).intercept(FixedValue.value(keyNamesBuilder.build())).make().load(TimingWrapper.class.getClassLoader(), strategy).getLoaded().getDeclaredConstructor(jaxRsSingletonClass).newInstance(jaxRsSingleton);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static class MethodImplementation
    implements Implementation {
        private static final FieldDescription.ForLoadedField TAGS_KEY_FIELD;
        private static final MethodDescription.ForLoadedMethod IMMUTABLE_LIST_BUILDER_METHOD;
        private static final MethodDescription.ForLoadedMethod LONG_VALUE_OF_METHOD;
        private static final MethodDescription.ForLoadedMethod DOUBLE_VALUE_OF_METHOD;
        private static final MethodDescription.ForLoadedMethod FLOAT_VALUE_OF_METHOD;
        private static final MethodDescription.ForLoadedMethod BOOLEAN_VALUE_OF_METHOD;
        private static final MethodDescription.ForLoadedMethod INTEGER_VALUE_OF_METHOD;
        private static final MethodDescription.ForLoadedMethod OPTIONAL_OF_NULLABLE_METHOD;
        private static final MethodDescription.ForLoadedMethod BUILDER_ADD_METHOD;
        private static final MethodDescription.ForLoadedMethod BUILDER_BUILD_METHOD;
        private static final MethodDescription.ForLoadedMethod CONTEXT_SET_PROPERTY_METHOD;
        private final Method delegateMethod;
        private final boolean hasKeyParameters;

        MethodImplementation(Method delegateMethod, boolean hasKeyParameters) {
            this.delegateMethod = delegateMethod;
            this.hasKeyParameters = hasKeyParameters;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                ImmutableList.Builder builder = ImmutableList.builder();
                ArrayList instrumentedMethodParameters = new ArrayList(instrumentedMethod.getParameters());
                if (this.hasKeyParameters) {
                    builder.add((Object[])new StackManipulation[]{MethodVariableAccess.load((ParameterDescription)instrumentedMethodParameters.remove(instrumentedMethodParameters.size() - 1)), FieldAccess.forField(TAGS_KEY_FIELD).read(), MethodInvocation.invoke(IMMUTABLE_LIST_BUILDER_METHOD)});
                    for (ParameterDescription parameterDescription : instrumentedMethod.getParameters()) {
                        if (!parameterDescription.getDeclaredAnnotations().isAnnotationPresent(Key.class)) continue;
                        builder.add((Object)MethodVariableAccess.load(parameterDescription));
                        TypeDescription.Generic type = parameterDescription.getType();
                        if (type.isPrimitive()) {
                            if (type.represents(Long.TYPE)) {
                                builder.add((Object)MethodInvocation.invoke(LONG_VALUE_OF_METHOD));
                            } else if (type.represents(Double.TYPE)) {
                                builder.add((Object)MethodInvocation.invoke(DOUBLE_VALUE_OF_METHOD));
                            } else if (type.represents(Float.TYPE)) {
                                builder.add((Object)MethodInvocation.invoke(FLOAT_VALUE_OF_METHOD));
                            } else if (type.represents(Boolean.TYPE)) {
                                builder.add((Object)MethodInvocation.invoke(BOOLEAN_VALUE_OF_METHOD));
                            } else if (!type.represents(Void.TYPE)) {
                                builder.add((Object)MethodInvocation.invoke(INTEGER_VALUE_OF_METHOD));
                            }
                        }
                        builder.add((Object[])new StackManipulation[]{MethodInvocation.invoke(OPTIONAL_OF_NULLABLE_METHOD), MethodInvocation.invoke(BUILDER_ADD_METHOD)});
                    }
                    builder.add((Object[])new StackManipulation[]{MethodInvocation.invoke(BUILDER_BUILD_METHOD), MethodInvocation.invoke(CONTEXT_SET_PROPERTY_METHOD)});
                }
                builder.add((Object[])new StackManipulation[]{MethodVariableAccess.REFERENCE.loadFrom(0), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)implementationTarget.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named("delegate"))).getOnly()).read()});
                for (ParameterDescription parameterDescription : instrumentedMethodParameters) {
                    builder.add((Object)MethodVariableAccess.load(parameterDescription));
                }
                builder.add((Object[])new StackManipulation[]{MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(this.delegateMethod.getDeclaringClass()).getDeclaredMethods().filter(ElementMatchers.is(this.delegateMethod))).getOnly()), MethodReturn.of(instrumentedMethod.getReturnType())});
                StackManipulation.Size size = new StackManipulation.Compound((List<? extends StackManipulation>)builder.build()).apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
            };
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        static {
            try {
                TAGS_KEY_FIELD = new FieldDescription.ForLoadedField(TimingFilter.class.getDeclaredField("TAGS_KEY"));
                IMMUTABLE_LIST_BUILDER_METHOD = new MethodDescription.ForLoadedMethod(ImmutableList.class.getMethod("builder", new Class[0]));
                LONG_VALUE_OF_METHOD = new MethodDescription.ForLoadedMethod(Long.class.getMethod("valueOf", Long.TYPE));
                DOUBLE_VALUE_OF_METHOD = new MethodDescription.ForLoadedMethod(Double.class.getMethod("valueOf", Double.TYPE));
                FLOAT_VALUE_OF_METHOD = new MethodDescription.ForLoadedMethod(Float.class.getMethod("valueOf", Float.TYPE));
                BOOLEAN_VALUE_OF_METHOD = new MethodDescription.ForLoadedMethod(Boolean.class.getMethod("valueOf", Boolean.TYPE));
                INTEGER_VALUE_OF_METHOD = new MethodDescription.ForLoadedMethod(Integer.class.getMethod("valueOf", Integer.TYPE));
                OPTIONAL_OF_NULLABLE_METHOD = new MethodDescription.ForLoadedMethod(Optional.class.getMethod("ofNullable", Object.class));
                BUILDER_ADD_METHOD = new MethodDescription.ForLoadedMethod(ImmutableList.Builder.class.getMethod("add", Object.class));
                BUILDER_BUILD_METHOD = new MethodDescription.ForLoadedMethod(ImmutableList.Builder.class.getMethod("build", new Class[0]));
                CONTEXT_SET_PROPERTY_METHOD = new MethodDescription.ForLoadedMethod(ContainerRequestContext.class.getMethod("setProperty", String.class, Object.class));
            }
            catch (NoSuchFieldException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

