/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jaxrs;

import com.google.common.reflect.TypeToken;
import com.proofpoint.jaxrs.BeanValidationException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.bval.jsr.ApacheValidationProvider;
import org.apache.bval.jsr.ApacheValidatorConfiguration;

public class ValidationUtils {
    private static final Validator VALIDATOR = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator();

    private ValidationUtils() {
    }

    public static void validateObject(Type genericType, Object object) throws BeanValidationException {
        Set violations = VALIDATOR.validate(object, new Class[0]);
        if (violations.isEmpty() && List.class.isAssignableFrom(TypeToken.of((Type)genericType).getRawType())) {
            violations = VALIDATOR.validate((Object)new ValidatableList((List)object), new Class[0]);
        } else if (violations.isEmpty() && Collection.class.isAssignableFrom(TypeToken.of((Type)genericType).getRawType())) {
            violations = VALIDATOR.validate((Object)new ValidatableCollection((Collection)object), new Class[0]);
        }
        if (violations.isEmpty() && Map.class.isAssignableFrom(TypeToken.of((Type)genericType).getRawType())) {
            violations = VALIDATOR.validate((Object)new ValidatableMap((Map)object), new Class[0]);
        }
        if (!violations.isEmpty()) {
            throw new BeanValidationException(violations);
        }
    }

    private static class ValidatableMap {
        @Valid
        private final Map<?, ?> map;

        ValidatableMap(Map<?, ?> map) {
            this.map = map;
        }
    }

    private static class ValidatableCollection {
        @Valid
        private final Collection<?> collection;

        ValidatableCollection(Collection<?> collection) {
            this.collection = collection;
        }
    }

    private static class ValidatableList {
        @Valid
        private final List<?> list;

        ValidatableList(List<?> list) {
            this.list = list;
        }
    }
}

