/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.proofpoint.jaxrs.AccessDoesNotRequireAuthentication;
import com.proofpoint.reporting.HealthBeanAttribute;
import com.proofpoint.reporting.HealthBeanRegistry;
import java.util.Objects;
import javax.inject.Inject;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/liveness")
@AccessDoesNotRequireAuthentication
public class LivenessResource {
    private final HealthBeanRegistry healthBeanRegistry;

    @Inject
    public LivenessResource(HealthBeanRegistry healthBeanRegistry) {
        this.healthBeanRegistry = Objects.requireNonNull(healthBeanRegistry, "healthBeanRegistry is null");
    }

    @GET
    @Produces(value={"text/plain"})
    public Response get() {
        StringBuilder sb = new StringBuilder();
        this.healthBeanRegistry.getHealthAttributes().values().stream().filter(healthBeanAttribute -> healthBeanAttribute.getType() == HealthBeanAttribute.Type.RESTART).forEach(attribute -> {
            try {
                String value = attribute.getValue();
                if (value != null) {
                    sb.append(value).append('\n');
                }
            }
            catch (MBeanException | ReflectionException e) {
                sb.append(e.toString()).append('\n');
            }
        });
        String failures = sb.toString();
        if (failures.isEmpty()) {
            return Response.ok((Object)"OK").build();
        }
        return Response.serverError().entity((Object)failures).build();
    }
}

