/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.log;

import com.proofpoint.log.Level;
import java.util.Arrays;
import java.util.IllegalFormatException;

public class Logger {
    private final java.util.logging.Logger logger;

    Logger(java.util.logging.Logger logger) {
        this.logger = logger;
    }

    public static Logger get(Class<?> clazz) {
        return Logger.get(clazz.getName());
    }

    public static Logger get(String name) {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(name);
        return new Logger(logger);
    }

    public void trace(String format, Object ... args) {
        if (this.logger.isLoggable(java.util.logging.Level.FINEST)) {
            String message;
            try {
                message = String.format(format, args);
            }
            catch (IllegalFormatException e) {
                this.logger.log(java.util.logging.Level.SEVERE, this.illegalFormatMessageFor(Level.TRACE, format, args), e);
                message = this.rawMessageFor(format, args);
            }
            this.logger.finest(message);
        }
    }

    public void debug(String format, Object ... args) {
        if (this.logger.isLoggable(java.util.logging.Level.FINE)) {
            String message;
            try {
                message = String.format(format, args);
            }
            catch (IllegalFormatException e) {
                this.logger.log(java.util.logging.Level.SEVERE, this.illegalFormatMessageFor(Level.DEBUG, format, args), e);
                message = this.rawMessageFor(format, args);
            }
            this.logger.fine(message);
        }
    }

    public void debug(Throwable exception, String format, Object ... args) {
        if (this.logger.isLoggable(java.util.logging.Level.FINE)) {
            String message;
            try {
                message = String.format(format, args);
            }
            catch (IllegalFormatException e) {
                this.logger.log(java.util.logging.Level.SEVERE, this.illegalFormatMessageFor(Level.DEBUG, format, args), e);
                message = this.rawMessageFor(format, args);
            }
            this.logger.log(java.util.logging.Level.FINE, message, exception);
        }
    }

    public void info(String format, Object ... args) {
        if (this.logger.isLoggable(java.util.logging.Level.INFO)) {
            String message;
            try {
                message = String.format(format, args);
            }
            catch (IllegalFormatException e) {
                this.logger.log(java.util.logging.Level.SEVERE, this.illegalFormatMessageFor(Level.INFO, format, args), e);
                message = this.rawMessageFor(format, args);
            }
            this.logger.info(message);
        }
    }

    public void warn(Throwable exception, String format, Object ... args) {
        if (this.logger.isLoggable(java.util.logging.Level.WARNING)) {
            String message;
            try {
                message = String.format(format, args);
            }
            catch (IllegalFormatException e) {
                this.logger.log(java.util.logging.Level.SEVERE, this.illegalFormatMessageFor(Level.WARN, format, args), e);
                message = this.rawMessageFor(format, args);
            }
            this.logger.log(java.util.logging.Level.WARNING, message, exception);
        }
    }

    public void warn(String format, Object ... args) {
        this.warn(null, format, args);
    }

    public void error(Throwable exception, String format, Object ... args) {
        if (this.logger.isLoggable(java.util.logging.Level.SEVERE)) {
            String message;
            try {
                message = String.format(format, args);
            }
            catch (IllegalFormatException e) {
                this.logger.log(java.util.logging.Level.SEVERE, this.illegalFormatMessageFor(Level.ERROR, format, args), e);
                message = this.rawMessageFor(format, args);
            }
            this.logger.log(java.util.logging.Level.SEVERE, message, exception);
        }
    }

    public void error(Throwable exception) {
        if (this.logger.isLoggable(java.util.logging.Level.SEVERE)) {
            this.logger.log(java.util.logging.Level.SEVERE, exception.getMessage(), exception);
        }
    }

    public void error(String format, Object ... args) {
        this.error(null, format, args);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.FINE);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(java.util.logging.Level.INFO);
    }

    private String illegalFormatMessageFor(Level level, String message, Object ... args) {
        return String.format("Invalid format string while trying to log: %s '%s' %s", new Object[]{level, message, Arrays.asList(args)});
    }

    private String rawMessageFor(String format, Object ... args) {
        return String.format("'%s' %s", format, Arrays.asList(args));
    }
}

