/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.log;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AsyncAppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.FileSize;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.proofpoint.log.Level;
import com.proofpoint.log.LogTester;
import com.proofpoint.log.Logger;
import com.proofpoint.log.LoggingConfiguration;
import com.proofpoint.log.LoggingOutputStream;
import com.proofpoint.log.NonCloseableOutputStream;
import com.proofpoint.log.OutputStreamHandler;
import com.proofpoint.log.RollingFileHandler;
import com.proofpoint.log.ShutdownWaitingLogManager;
import com.proofpoint.units.DataSize;
import com.proofpoint.units.Duration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import javax.annotation.concurrent.GuardedBy;

public class Logging {
    private static final Logger log = Logger.get(Logging.class);
    private static final String ROOT_LOGGER_NAME = "";
    private static final java.util.logging.Logger ROOT = java.util.logging.Logger.getLogger("");
    private static final java.util.logging.Logger BOOTSTRAP_LOGGER = java.util.logging.Logger.getLogger("Bootstrap");
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final FileSize BUFFER_SIZE_IN_BYTES = new FileSize(new DataSize(1.0, DataSize.Unit.MEGABYTE).toBytes());
    private static Logging instance;
    private final Map<String, java.util.logging.Logger> loggers = new ConcurrentHashMap<String, java.util.logging.Logger>();
    private final Multimap<java.util.logging.Logger, Handler> testingHandlers = Multimaps.synchronizedMultimap((Multimap)ArrayListMultimap.create());
    @GuardedBy(value="this")
    private OutputStreamHandler consoleHandler;

    public static synchronized Logging initialize() {
        if (instance == null) {
            instance = new Logging();
        }
        return instance;
    }

    private Logging() {
        ROOT.setLevel(Level.INFO.toJulLevel());
        for (Handler handler : ROOT.getHandlers()) {
            ROOT.removeHandler(handler);
        }
        this.rewireStdStreams();
    }

    private void rewireStdStreams() {
        this.logConsole(new NonCloseableOutputStream(System.err));
        log.info("Logging to stderr", new Object[0]);
        Logging.redirectStdStreams();
    }

    private static void redirectStdStreams() {
        try {
            System.setOut(new PrintStream((OutputStream)new LoggingOutputStream(Logger.get("stdout")), true, "UTF-8"));
            System.setErr(new PrintStream((OutputStream)new LoggingOutputStream(Logger.get("stderr")), true, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private synchronized void logConsole(OutputStream stream) {
        this.consoleHandler = new OutputStreamHandler(stream);
        ROOT.addHandler(this.consoleHandler);
    }

    public synchronized void disableConsole() {
        log.info("Disabling stderr output", new Object[0]);
        ROOT.removeHandler(this.consoleHandler);
        this.consoleHandler = null;
    }

    public void logToFile(String logPath, int maxHistory, DataSize maxSize, DataSize maxTotalSize) {
        log.info("Logging to %s", logPath);
        RollingFileHandler rollingFileHandler = new RollingFileHandler(logPath, maxHistory, maxSize, maxTotalSize);
        ROOT.addHandler(rollingFileHandler);
    }

    @VisibleForTesting
    public static void addLogTester(Class<?> clazz, LogTester logTester) {
        Logging.addLogTester(clazz.getName(), logTester);
    }

    @VisibleForTesting
    public static void addLogTester(String name, final LogTester logTester) {
        Preconditions.checkState((instance != null ? 1 : 0) != 0, (Object)"Logging is not initialized");
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(name);
        Handler handler = new Handler(){

            @Override
            public void publish(LogRecord record) {
                logTester.log(Level.fromJulLevel(record.getLevel()), record.getMessage(), Optional.ofNullable(record.getThrown()));
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        };
        Logging.instance.testingHandlers.put((Object)logger, (Object)handler);
        logger.addHandler(handler);
    }

    @VisibleForTesting
    public static void resetLogTesters() {
        if (instance == null) {
            return;
        }
        for (Map.Entry entry : Logging.instance.testingHandlers.entries()) {
            ((java.util.logging.Logger)entry.getKey()).removeHandler((Handler)entry.getValue());
        }
        Logging.instance.testingHandlers.clear();
    }

    public static <T> Appender<T> createFileAppender(String logPath, int maxHistory, DataSize maxFileSize, DataSize maxTotalSize, Encoder<T> encoder, Context context) {
        return Logging.createFileAppender(logPath, maxHistory, 0, new Duration(0.0, TimeUnit.SECONDS), maxFileSize, maxTotalSize, encoder, context);
    }

    public static <T> Appender<T> createFileAppender(String logPath, int maxHistory, int queueSize, Duration flushInterval, DataSize maxFileSize, DataSize maxTotalSize, Encoder<T> encoder, Context context) {
        FlushingFileAppender fileAppender;
        Logging.recoverTempFiles(logPath);
        if (queueSize > 0) {
            fileAppender = new FlushingFileAppender(flushInterval);
            fileAppender.setBufferSize(BUFFER_SIZE_IN_BYTES);
            fileAppender.setImmediateFlush(false);
        } else {
            fileAppender = new FlushingFileAppender();
        }
        SizeAndTimeBasedRollingPolicy rollingPolicy = new SizeAndTimeBasedRollingPolicy();
        rollingPolicy.setContext(context);
        rollingPolicy.setFileNamePattern(logPath + "-%d{yyyy-MM-dd}.%i.log.gz");
        rollingPolicy.setMaxHistory(maxHistory);
        rollingPolicy.setTotalSizeCap(new FileSize(maxTotalSize.toBytes()));
        rollingPolicy.setParent(fileAppender);
        rollingPolicy.setMaxFileSize(new FileSize(maxFileSize.toBytes()));
        fileAppender.setContext(context);
        fileAppender.setFile(logPath);
        fileAppender.setAppend(true);
        fileAppender.setEncoder(encoder);
        fileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        AsyncAppenderBase asyncAppender = null;
        if (queueSize > 0) {
            asyncAppender = new AsyncAppenderBase();
            asyncAppender.setContext(context);
            asyncAppender.setQueueSize(queueSize);
            asyncAppender.addAppender(fileAppender);
        }
        rollingPolicy.start();
        fileAppender.start();
        if (queueSize > 0) {
            asyncAppender.start();
            return asyncAppender;
        }
        return fileAppender;
    }

    public Level getRootLevel() {
        return this.getLevel(ROOT_LOGGER_NAME);
    }

    public void setRootLevel(Level newLevel) {
        this.setLevel(ROOT_LOGGER_NAME, newLevel);
    }

    public void setLevels(File file) throws IOException {
        Properties properties = new Properties();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        this.processLevels(properties);
    }

    public Level getLevel(String loggerName) {
        return Logging.getEffectiveLevel(java.util.logging.Logger.getLogger(loggerName));
    }

    private static Level getEffectiveLevel(java.util.logging.Logger logger) {
        java.util.logging.Logger parent;
        java.util.logging.Level level = logger.getLevel();
        if (level == null && (parent = logger.getParent()) != null) {
            return Logging.getEffectiveLevel(parent);
        }
        if (level == null) {
            return Level.OFF;
        }
        return Level.fromJulLevel(level);
    }

    public void setLevel(String loggerName, Level level) {
        this.loggers.computeIfAbsent(loggerName, java.util.logging.Logger::getLogger).setLevel(level.toJulLevel());
    }

    public Map<String, Level> getAllLevels() {
        ImmutableSortedMap.Builder levels = ImmutableSortedMap.naturalOrder();
        for (String loggerName : Collections.list(LogManager.getLogManager().getLoggerNames())) {
            java.util.logging.Level level = java.util.logging.Logger.getLogger(loggerName).getLevel();
            if (level == null) continue;
            levels.put((Object)loggerName, (Object)Level.fromJulLevel(level));
        }
        return levels.build();
    }

    private void processLevels(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String loggerName = entry.getKey().toString();
            Level level = Level.valueOf(entry.getValue().toString().toUpperCase(Locale.US));
            this.setLevel(loggerName, level);
        }
    }

    private static void recoverTempFiles(String logPath) {
        File logPathFile = new File(logPath).getParentFile();
        File[] tempFiles = logPathFile.listFiles((dir, name) -> name.endsWith(TEMP_FILE_EXTENSION));
        if (tempFiles == null) {
            return;
        }
        for (File tempFile : tempFiles) {
            String newName = tempFile.getName().substring(0, tempFile.getName().length() - TEMP_FILE_EXTENSION.length());
            File newFile = new File(tempFile.getParent(), newName + LOG_FILE_EXTENSION);
            if (tempFile.renameTo(newFile)) continue;
            log.warn("Could not rename temp file [%s] to [%s]", tempFile, newFile);
        }
    }

    public void configure(LoggingConfiguration config) throws IOException {
        if (config.getLogPath() == null && !config.isConsoleEnabled()) {
            throw new IllegalArgumentException("No log file is configured (log.path) and logging to console is disabled (log.enable-console)");
        }
        if (config.getLogPath() != null) {
            this.logToFile(config.getLogPath(), config.getMaxHistory(), config.getMaxSegmentSize(), config.getMaxTotalSize());
        }
        if (!config.isConsoleEnabled()) {
            this.disableConsole();
        }
        if (config.getLevelsFile() != null) {
            this.setLevels(new File(config.getLevelsFile()));
        }
        if (config.getBootstrapLogPath() != null) {
            Logging.setupBootstrapLog(config.getBootstrapLogPath());
        }
    }

    private static void setupBootstrapLog(String logPath) throws IOException {
        Path path = Paths.get(logPath, new String[0]);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        final BufferedWriter writer = Files.newBufferedWriter(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        BOOTSTRAP_LOGGER.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                try {
                    writer.write(record.getMessage());
                    writer.newLine();
                    writer.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void flush() {
                try {
                    writer.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void close() {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public static void addShutdownLatchToWaitFor(CountDownLatch latch) {
        LogManager logManager = LogManager.getLogManager();
        if (logManager instanceof ShutdownWaitingLogManager) {
            ((ShutdownWaitingLogManager)logManager).addWaitFor(latch);
        } else {
            log.warn("LogManager is not a ShutdownWaitingLogManager, so shutdown hooks might not be able to log. Please run java with -Djava.util.logging.manager=%s", ShutdownWaitingLogManager.class.getTypeName());
        }
    }

    @Deprecated
    public static void addShutdownHookToWaitFor(Thread shutdownHook) {
        LogManager logManager = LogManager.getLogManager();
        if (logManager instanceof ShutdownWaitingLogManager) {
            ((ShutdownWaitingLogManager)logManager).addWaitForShutdownHook(shutdownHook);
        } else {
            log.warn("LogManager is not a ShutdownWaitingLogManager, so shutdown hooks might not be able to log. Please run java with -Djava.util.logging.manager=%s", ShutdownWaitingLogManager.class.getTypeName());
        }
    }

    @Deprecated
    public static void removeShutdownHookToWaitFor(Thread shutdownHook) {
        LogManager logManager = LogManager.getLogManager();
        if (logManager instanceof ShutdownWaitingLogManager) {
            ((ShutdownWaitingLogManager)logManager).removeWaitForShutdownHook(shutdownHook);
        }
    }

    private static class FlushingFileAppender<T>
    extends RollingFileAppender<T> {
        private final AtomicLong lastFlushed = new AtomicLong(System.nanoTime());
        private final long flushIntervalNanos;

        private FlushingFileAppender(Duration flushInterval) {
            this.flushIntervalNanos = flushInterval.roundTo(TimeUnit.NANOSECONDS);
        }

        protected void subAppend(T event) {
            super.subAppend(event);
            long now = System.nanoTime();
            long last = this.lastFlushed.get();
            if (now - last > this.flushIntervalNanos && this.lastFlushed.compareAndSet(last, now)) {
                this.flush();
            }
        }

        private void flush() {
            try {
                this.lock.lock();
                try {
                    this.getOutputStream().flush();
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (IOException e) {
                this.started = false;
                this.addStatus((Status)new ErrorStatus("IO failure in appender", (Object)this, (Throwable)e));
            }
        }
    }
}

