/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.log;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.proofpoint.log.Level;
import com.proofpoint.log.Logging;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.weakref.jmx.Managed;

public class LoggingMBean {
    private final Logging logging;

    @Inject
    public LoggingMBean(Logging logging) {
        this.logging = logging;
    }

    @Managed
    public String getLevel(String loggerName) {
        return this.logging.getLevel(loggerName).toString();
    }

    @Managed
    public void setLevel(String loggerName, String newLevel) {
        this.logging.setLevel(loggerName, Level.valueOf(newLevel.toUpperCase(Locale.US)));
    }

    @Managed
    public String getRootLevel() {
        return this.logging.getRootLevel().toString();
    }

    @Managed
    public void setRootLevel(String newLevel) {
        this.logging.setRootLevel(Level.valueOf(newLevel.toUpperCase(Locale.US)));
    }

    @Managed
    public Map<String, String> getAllLevels() {
        return ImmutableSortedMap.copyOf((Map)Maps.transformValues(this.logging.getAllLevels(), (Function)Functions.toStringFunction()));
    }
}

