/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.log;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.LogManager;

public class ShutdownWaitingLogManager
extends LogManager {
    private final Set<Thread> shutdownHooksToWaitFor = new HashSet<Thread>();
    private final Set<CountDownLatch> latchesToWaitFor = new HashSet<CountDownLatch>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws SecurityException {
        try {
            Set<Object> set = this.latchesToWaitFor;
            synchronized (set) {
                for (CountDownLatch latch : this.latchesToWaitFor) {
                    latch.await();
                }
            }
            set = this.shutdownHooksToWaitFor;
            synchronized (set) {
                for (Thread thread : this.shutdownHooksToWaitFor) {
                    thread.join();
                }
                this.shutdownHooksToWaitFor.clear();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWaitFor(CountDownLatch latch) {
        Set<CountDownLatch> set = this.latchesToWaitFor;
        synchronized (set) {
            this.latchesToWaitFor.add(latch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addWaitForShutdownHook(Thread shutdownHook) {
        Set<Thread> set = this.shutdownHooksToWaitFor;
        synchronized (set) {
            this.shutdownHooksToWaitFor.add(shutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeWaitForShutdownHook(Thread shutdownHook) {
        Set<Thread> set = this.shutdownHooksToWaitFor;
        synchronized (set) {
            this.shutdownHooksToWaitFor.remove(shutdownHook);
        }
    }
}

