/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jmx;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.proofpoint.jmx.GuiceDependencyIterator;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

class GuiceInjectorIterator
implements Iterator<Class<?>>,
Iterable<Class<?>> {
    private final Set<Key<?>> visited = new HashSet();
    private final Iterator<Key<?>> keyIterator;
    private final Injector injector;
    private boolean needsReset = true;
    private Class<?> currentClass = null;
    private GuiceDependencyIterator currentDependencyIterator = null;

    public GuiceInjectorIterator(Injector injector) {
        this.injector = injector;
        this.keyIterator = injector.getBindings().keySet().iterator();
    }

    @Override
    public boolean hasNext() {
        this.checkReset();
        return this.currentClass != null;
    }

    @Override
    public Class<?> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.needsReset = true;
        return this.currentClass;
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return new GuiceInjectorIterator(this.injector);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void checkReset() {
        if (!this.needsReset) {
            return;
        }
        this.needsReset = false;
        this.currentClass = null;
        if (this.currentDependencyIterator != null) {
            if (this.currentDependencyIterator.hasNext()) {
                this.currentClass = this.currentDependencyIterator.next();
            } else {
                this.currentDependencyIterator = null;
            }
        }
        while (this.currentClass == null && this.keyIterator.hasNext()) {
            Key<?> key = this.keyIterator.next();
            this.currentClass = GuiceInjectorIterator.parseKey(this.visited, key);
            if (this.currentClass == null) continue;
            this.currentDependencyIterator = new GuiceDependencyIterator(key.getTypeLiteral());
            this.currentDependencyIterator = this.currentDependencyIterator.substituteVisitedSet(this.visited);
        }
    }

    static Class<?> parseKey(Set<Key<?>> visited, Key<?> key) {
        if (visited.contains(key)) {
            return null;
        }
        visited.add(key);
        Type type = key.getTypeLiteral().getType();
        if (type instanceof GenericArrayType) {
            type = ((GenericArrayType)type).getGenericComponentType();
        }
        Class clazz = type instanceof Class ? (Class)type : key.getTypeLiteral().getRawType();
        return clazz;
    }
}

