/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jmx;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.proofpoint.configuration.ConfigBinder;
import com.proofpoint.jmx.JavaVersion;
import com.proofpoint.jmx.JmxAgent;
import com.proofpoint.jmx.JmxAgent8;
import com.proofpoint.jmx.JmxAgent9;
import com.proofpoint.jmx.JmxConfig;
import com.proofpoint.jmx.StackTraceMBean;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import org.weakref.jmx.guice.ExportBinder;

public class JmxModule
implements Module {
    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(MBeanServer.class).toInstance((Object)ManagementFactory.getPlatformMBeanServer());
        ConfigBinder.bindConfig((Binder)binder).bind(JmxConfig.class);
        ExportBinder.newExporter((Binder)binder).export(StackTraceMBean.class).withGeneratedName();
        binder.bind(StackTraceMBean.class).in(Scopes.SINGLETON);
        if (JavaVersion.current().getMajor() < 9) {
            binder.bind(JmxAgent8.class).in(Scopes.SINGLETON);
            binder.bind(JmxAgent.class).to(JmxAgent8.class);
        } else {
            binder.bind(JmxAgent9.class).in(Scopes.SINGLETON);
            binder.bind(JmxAgent.class).to(JmxAgent9.class);
        }
    }
}

