/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import com.proofpoint.http.client.BodySource;
import com.proofpoint.http.client.DynamicBodySource;
import com.proofpoint.http.client.HttpClient;
import com.proofpoint.http.client.Request;
import com.proofpoint.http.client.ResponseHandler;
import com.proofpoint.http.client.StringResponseHandler;
import com.proofpoint.log.Logger;
import com.proofpoint.node.NodeInfo;
import com.proofpoint.reporting.ForReportClient;
import com.proofpoint.reporting.ReportClientConfig;
import com.proofpoint.reporting.ReportTagConfig;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.inject.Inject;

class ReportClient {
    private static final Logger logger = Logger.get(ReportClient.class);
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final URI UPLOAD_URI = URI.create("api/v1/datapoints");
    private final Map<String, String> instanceTags;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;

    @Inject
    ReportClient(NodeInfo nodeInfo, @ForReportClient HttpClient httpClient, ReportClientConfig reportClientConfig, ReportTagConfig reportTagConfig, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(reportClientConfig, "reportClientConfig is null");
        Objects.requireNonNull(reportTagConfig, "reportTagConfig is null");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"application", (Object)nodeInfo.getApplication());
        builder.put((Object)"host", (Object)nodeInfo.getInternalHostname());
        builder.put((Object)"environment", (Object)nodeInfo.getEnvironment());
        builder.put((Object)"pool", (Object)nodeInfo.getPool());
        builder.putAll(reportTagConfig.getTags());
        this.instanceTags = builder.build();
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
    }

    public void report(long systemTimeMillis, Table<String, Map<String, String>, Object> collectedData) {
        Request request = Request.Builder.preparePost().setUri(UPLOAD_URI).setHeader("Content-Type", "application/gzip").setBodySource((BodySource)new CompressBodySource(systemTimeMillis, collectedData)).build();
        try {
            StringResponseHandler.StringResponse response = (StringResponseHandler.StringResponse)this.httpClient.execute(request, (ResponseHandler)StringResponseHandler.createStringResponseHandler());
            if (response.getStatusCode() != 204) {
                logger.warn("Failed to report stats: %s %s %s", new Object[]{response.getStatusCode(), response.getStatusMessage(), response.getBody()});
            }
        }
        catch (RuntimeException e) {
            logger.warn((Throwable)e, "Exception when trying to report stats", new Object[0]);
        }
    }

    private class CompressBodySource
    implements DynamicBodySource {
        private final long systemTimeMillis;
        private final Table<String, Map<String, String>, Object> collectedData;

        CompressBodySource(long systemTimeMillis, Table<String, Map<String, String>, Object> collectedData) {
            this.systemTimeMillis = systemTimeMillis;
            this.collectedData = collectedData;
        }

        public DynamicBodySource.Writer start(OutputStream out) throws Exception {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(out);
            JsonGenerator generator = JSON_FACTORY.createGenerator((OutputStream)gzipOutputStream, JsonEncoding.UTF8).setCodec((ObjectCodec)ReportClient.this.objectMapper);
            Iterator iterator = this.collectedData.cellSet().iterator();
            generator.writeStartArray();
            return () -> {
                if (iterator.hasNext()) {
                    generator.writeObject((Object)new DataPoint(this.systemTimeMillis, (Table.Cell<String, Map<String, String>, Object>)((Table.Cell)iterator.next()), ReportClient.this.instanceTags));
                } else {
                    generator.writeEndArray();
                    generator.flush();
                    gzipOutputStream.finish();
                    out.close();
                }
            };
        }
    }

    private static class DataPoint {
        private static final Pattern NOT_ACCEPTED_CHARACTER_PATTERN = Pattern.compile("[^-A-Za-z0-9./_]");
        @JsonProperty
        private final String name;
        @JsonProperty
        private final long timestamp;
        @JsonProperty
        private final String type;
        @JsonProperty
        private final Object value;
        @JsonProperty
        private final Map<String, String> tags;

        DataPoint(long systemTimeMillis, Table.Cell<String, Map<String, String>, Object> cell, Map<String, String> instanceTags) {
            this.name = NOT_ACCEPTED_CHARACTER_PATTERN.matcher((CharSequence)cell.getRowKey()).replaceAll("_");
            this.timestamp = systemTimeMillis;
            this.value = cell.getValue();
            this.type = this.value instanceof Number ? null : "string";
            ImmutableMap.Builder builder = ImmutableMap.builder().putAll(instanceTags);
            for (Map.Entry entry : ((Map)cell.getColumnKey()).entrySet()) {
                builder.put(entry.getKey(), (Object)NOT_ACCEPTED_CHARACTER_PATTERN.matcher((CharSequence)entry.getValue()).replaceAll("_"));
            }
            this.tags = builder.build();
        }
    }
}

