/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.proofpoint.log.Logger;
import com.proofpoint.node.NodeInfo;
import com.proofpoint.reporting.MinuteBucketIdProvider;
import com.proofpoint.reporting.ReportSink;
import com.proofpoint.reporting.ReportUtils;
import com.proofpoint.reporting.ReportedBeanAttribute;
import com.proofpoint.reporting.ReportedBeanRegistry;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.management.MBeanException;
import javax.management.ReflectionException;

public class ReportCollector {
    private static final Logger log = Logger.get(ReportCollector.class);
    private final String applicationPrefix;
    private final MinuteBucketIdProvider bucketIdProvider;
    private final ReportedBeanRegistry reportedBeanRegistry;
    private final ReportSink reportSink;
    private final Map<String, String> versionTags;

    @Inject
    ReportCollector(NodeInfo nodeInfo, MinuteBucketIdProvider bucketIdProvider, ReportedBeanRegistry reportedBeanRegistry, ReportSink reportSink) {
        this.applicationPrefix = CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, nodeInfo.getApplication()) + ".";
        this.bucketIdProvider = Objects.requireNonNull(bucketIdProvider, "bucketIdProvider is null");
        this.reportedBeanRegistry = Objects.requireNonNull(reportedBeanRegistry, "reportedBeanRegistry is null");
        this.reportSink = Objects.requireNonNull(reportSink, "reportSink is null");
        ImmutableMap.Builder versionTagsBuilder = ImmutableMap.builder();
        if (!nodeInfo.getApplicationVersion().isEmpty()) {
            versionTagsBuilder.put((Object)"applicationVersion", (Object)nodeInfo.getApplicationVersion());
        }
        if (!nodeInfo.getPlatformVersion().isEmpty()) {
            versionTagsBuilder.put((Object)"platformVersion", (Object)nodeInfo.getPlatformVersion());
        }
        this.versionTags = versionTagsBuilder.build();
    }

    public void collectData() {
        try {
            long lastSystemTimeMillis = this.bucketIdProvider.getLastSystemTimeMillis();
            ImmutableTable.Builder builder = ImmutableTable.builder();
            int numAttributes = 0;
            for (ReportedBeanRegistry.RegistrationInfo registrationInfo : this.reportedBeanRegistry.getReportedBeans()) {
                for (ReportedBeanAttribute attribute : registrationInfo.getReportedBean().getAttributes()) {
                    Object value = null;
                    try {
                        value = attribute.getValue(null);
                    }
                    catch (MBeanException | ReflectionException jMException) {
                        // empty catch block
                    }
                    if (value == null || !ReportUtils.isReportable((Object)value)) continue;
                    if (!(value instanceof Number)) {
                        value = value.toString();
                    }
                    ++numAttributes;
                    StringBuilder stringBuilder = new StringBuilder();
                    if (registrationInfo.isApplicationPrefix()) {
                        stringBuilder.append(this.applicationPrefix);
                    }
                    String name = stringBuilder.append(registrationInfo.getNamePrefix()).append('.').append(attribute.getName()).toString();
                    builder.put((Object)name, (Object)registrationInfo.getTags(), value);
                }
            }
            builder.put((Object)"ReportCollector.NumMetrics", this.versionTags, (Object)numAttributes);
            this.reportSink.report(lastSystemTimeMillis, (Table<String, Map<String, String>, Object>)builder.build());
        }
        catch (Throwable e) {
            log.error(e, "Unexpected exception from report collection", new Object[0]);
        }
    }

    Map<String, String> getVersionTags() {
        return this.versionTags;
    }
}

