/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.common.collect.Table;
import com.proofpoint.reporting.ForReportClient;
import com.proofpoint.reporting.ReportClient;
import com.proofpoint.reporting.ReportClientConfig;
import com.proofpoint.reporting.ReportSink;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;

class ReportQueue
implements ReportSink {
    private final boolean enabled;
    private final ExecutorService clientExecutorService;
    private final ReportClient reportClient;

    @Inject
    ReportQueue(ReportClientConfig reportClientConfig, @ForReportClient ExecutorService clientExecutorService, ReportClient reportClient) {
        this.enabled = reportClientConfig.isEnabled();
        this.clientExecutorService = Objects.requireNonNull(clientExecutorService, "clientExecutorService is null");
        this.reportClient = reportClient;
    }

    @Override
    public void report(long systemTimeMillis, Table<String, Map<String, String>, Object> collectedData) {
        if (!this.enabled) {
            return;
        }
        this.clientExecutorService.submit(() -> this.reportClient.report(systemTimeMillis, collectedData));
    }
}

