/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.proofpoint.reporting.ForReportCollector;
import com.proofpoint.reporting.ReportCollector;
import com.proofpoint.reporting.ReportSink;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;

class ReportScheduler {
    private final ScheduledExecutorService collectionExecutorService;
    private final ReportCollector reportCollector;
    private final ReportSink reportSink;

    @Inject
    ReportScheduler(ReportCollector reportCollector, ReportSink reportSink, @ForReportCollector ScheduledExecutorService collectionExecutorService) {
        this.reportCollector = Objects.requireNonNull(reportCollector, "reportCollector is null");
        this.reportSink = Objects.requireNonNull(reportSink, "reportQueue is null");
        this.collectionExecutorService = Objects.requireNonNull(collectionExecutorService, "collectionExecutorService is null");
    }

    @PostConstruct
    public void start() {
        this.collectionExecutorService.scheduleAtFixedRate(this.reportCollector::collectData, 1L, 1L, TimeUnit.MINUTES);
        this.reportSink.report(System.currentTimeMillis(), (Table<String, Map<String, String>, Object>)ImmutableTable.of((Object)"ReportCollector.ServerStart", this.reportCollector.getVersionTags(), (Object)1));
    }
}

