/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.proofpoint.concurrent.Threads;
import com.proofpoint.configuration.ConfigBinder;
import com.proofpoint.discovery.client.DiscoveryBinder;
import com.proofpoint.reporting.ForReportClient;
import com.proofpoint.reporting.ForReportCollector;
import com.proofpoint.reporting.ReportClient;
import com.proofpoint.reporting.ReportClientConfig;
import com.proofpoint.reporting.ReportCollector;
import com.proofpoint.reporting.ReportQueue;
import com.proofpoint.reporting.ReportScheduler;
import com.proofpoint.reporting.ReportSink;
import com.proofpoint.reporting.ReportingBaseMetricsModule;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ReportingClientModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(ReportScheduler.class).in(Scopes.SINGLETON);
        binder.bind(ReportCollector.class).in(Scopes.SINGLETON);
        binder.bind(ReportSink.class).to(ReportQueue.class).in(Scopes.SINGLETON);
        binder.bind(ReportClient.class).in(Scopes.SINGLETON);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindDiscoveredHttpClient("reporting", ForReportClient.class);
        ConfigBinder.bindConfig((Binder)binder).bind(ReportClientConfig.class);
        binder.install((Module)new ReportingBaseMetricsModule());
    }

    @Provides
    @ForReportCollector
    private static ScheduledExecutorService createCollectionExecutorService() {
        return Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"reporting-collector-%s"));
    }

    @Provides
    @ForReportClient
    private static ExecutorService createClientExecutorService() {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.NANOSECONDS, new LinkedBlockingQueue<Runnable>(5), Threads.daemonThreadsNamed((String)"reporting-client-%s"), new ThreadPoolExecutor.DiscardOldestPolicy());
    }
}

