/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting.testing;

import com.google.common.collect.Table;
import com.proofpoint.reporting.ReportCollector;
import com.proofpoint.reporting.ReportSink;
import com.proofpoint.reporting.testing.TestingBucketIdProvider;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public class ReportingTester {
    private final TestingBucketIdProvider bucketIdProvider;
    private final ReportCollector reportCollector;
    private final TestingSink testingSink;

    @Inject
    public ReportingTester(TestingBucketIdProvider bucketIdProvider, ReportCollector reportCollector, TestingSink testingSink) {
        this.bucketIdProvider = Objects.requireNonNull(bucketIdProvider, "bucketIdProvider is null");
        this.reportCollector = Objects.requireNonNull(reportCollector, "reportCollector is null");
        this.testingSink = Objects.requireNonNull(testingSink, "testingSink is null");
    }

    public Table<String, Map<String, String>, Object> collectData() {
        this.bucketIdProvider.incrementBucket();
        this.reportCollector.collectData();
        return this.testingSink.getCollectedData();
    }

    static class TestingSink
    implements ReportSink {
        private Table<String, Map<String, String>, Object> collectedData;

        TestingSink() {
        }

        @Override
        public void report(long systemTimeMillis, Table<String, Map<String, String>, Object> collectedData) {
            this.collectedData = collectedData;
        }

        Table<String, Map<String, String>, Object> getCollectedData() {
            return this.collectedData;
        }
    }
}

