/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.launcher;

import com.proofpoint.launcher.PidStatus;
import com.proofpoint.launcher.PidStatusSource;
import com.proofpoint.launcher.Processes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class LegacyPidFile
implements PidStatusSource {
    private final String pidFilePath;

    public LegacyPidFile(String pidFilePath) {
        this.pidFilePath = Objects.requireNonNull(pidFilePath, "pidFilePath is null");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PidStatus getStatus() {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.pidFilePath), StandardCharsets.US_ASCII));){
            int pid;
            String line = reader.readLine();
            if (line != null && Processes.exists(pid = Integer.decode(line).intValue())) {
                PidStatus pidStatus = PidStatus.heldBy(pid);
                return pidStatus;
            }
        }
        catch (FileNotFoundException e) {
            return PidStatus.notHeld();
        }
        catch (IOException | NumberFormatException exception) {
            // empty catch block
        }
        if (new File(this.pidFilePath).delete()) return PidStatus.notHeld();
        return PidStatus.notHeld();
    }
}

