/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.launcher;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.proofpoint.launcher.AlreadyRunningError;
import com.proofpoint.launcher.LegacyPidFile;
import com.proofpoint.launcher.PidFile;
import com.proofpoint.launcher.PidStatus;
import com.proofpoint.launcher.PidStatusSource;
import com.proofpoint.launcher.Processes;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.airlift.command.Arguments;
import io.airlift.command.Cli;
import io.airlift.command.Command;
import io.airlift.command.Help;
import io.airlift.command.Option;
import io.airlift.command.OptionType;
import io.airlift.command.ParseException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.locks.LockSupport;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

@SuppressFBWarnings(value={"DM_EXIT"}, justification="Need to return specific exit codes")
public final class Main {
    private static final int STATUS_GENERIC_ERROR = 1;
    private static final int STATUS_INVALID_ARGS = 2;
    private static final int STATUS_UNSUPPORTED = 3;
    private static final int STATUS_CONFIG_MISSING = 6;
    private static final int STATUS_NOT_RUNNING = 3;

    private Main() {
    }

    public static void main(String[] args) {
        Runnable parse;
        Cli cli = Cli.buildCli((String)"launcher", Runnable.class).withDescription("The service launcher").withCommands(Help.class, new Class[]{StartCommand.class, StartClientCommand.class, RunCommand.class, RunClientCommand.class, RestartCommand.class, TryRestartCommand.class, ForceReloadCommand.class, StatusCommand.class, StopCommand.class, KillCommand.class}).build();
        try {
            parse = (Runnable)cli.parse(args);
        }
        catch (ParseException e) {
            parse = new ParseError(e, (Cli<Runnable>)cli);
        }
        parse.run();
    }

    @Command(name="ParseError")
    public static class ParseError
    implements Runnable {
        private final ParseException e;
        private final Cli<Runnable> cli;

        public ParseError(ParseException e, Cli<Runnable> cli) {
            this.e = e;
            this.cli = cli;
        }

        @Override
        public void run() {
            int status = this.e.getMessage().equals("No command specified") ? 3 : 2;
            System.err.println(this.e.getMessage());
            System.err.print("\n");
            ((Runnable)this.cli.parse(new String[]{"help"})).run();
            System.exit(status);
        }
    }

    @Command(name="kill", description="Hard stop of server")
    public static class KillCommand
    extends LauncherCommand {
        @Override
        public void execute() {
            LauncherCommand.KillStatus killStatus = this.killProcess(false);
            System.out.println(killStatus.msg);
            System.exit(killStatus.exitCode);
        }
    }

    @Command(name="stop", description="Stop server gracefully")
    public static class StopCommand
    extends LauncherCommand {
        @Override
        public void execute() {
            LauncherCommand.KillStatus killStatus = this.killProcess(true);
            System.out.println(killStatus.msg);
            System.exit(killStatus.exitCode);
        }
    }

    @Command(name="force-reload", description="Cause server configuration to be reloaded")
    public static class ForceReloadCommand
    extends TryRestartCommand {
    }

    @Command(name="try-restart", description="Restart server gracefully if it is already running")
    public static class TryRestartCommand
    extends LauncherCommand {
        @Arguments(description="Arguments to pass to server")
        public final List<String> args = new ArrayList<String>();

        @Override
        public void execute() {
            PidFile pidFile = new PidFile(this.pidFilePath);
            PidStatus pidStatus = pidFile.getStatus();
            if (!pidStatus.held) {
                System.out.println("Not running");
                System.exit(0);
            }
            LauncherCommand.KillStatus killStatus = this.killProcess(true);
            if (killStatus.exitCode != 0) {
                System.out.println(killStatus.msg);
                System.exit(killStatus.exitCode);
            }
            this.start(this.args, true);
        }
    }

    @Command(name="restart", description="Restart server gracefully")
    public static class RestartCommand
    extends LauncherCommand {
        @Arguments(description="Arguments to pass to server")
        public final List<String> args = new ArrayList<String>();

        @Override
        public void execute() {
            LauncherCommand.KillStatus killStatus = this.killProcess(true);
            if (killStatus.exitCode != 0) {
                System.out.println(killStatus.msg);
                System.exit(killStatus.exitCode);
            }
            this.start(this.args, true);
        }
    }

    @Command(name="status", description="Check status of server")
    public static class StatusCommand
    extends LauncherCommand {
        @Override
        public void execute() {
            PidFile pidFile = new PidFile(this.pidFilePath);
            PidStatus pidStatus = pidFile.getStatus();
            if (pidStatus.held) {
                Integer pid = pidStatus.pid;
                String msg = "Starting";
                pidStatus = pidFile.getRunning();
                if (pidStatus.held) {
                    msg = "Running";
                    if (pidStatus.pid != 0) {
                        pid = pidStatus.pid;
                    }
                }
                if (pid != 0) {
                    msg = msg + " as " + pid;
                }
                System.out.println(msg);
                System.exit(0);
            }
            if (this.legacyPidFilePath != null) {
                pidStatus = new LegacyPidFile(this.legacyPidFilePath).getStatus();
                if (pidStatus.held) {
                    System.out.println("Running as " + pidStatus.pid);
                    System.exit(0);
                }
            }
            System.out.println("Not running");
            System.exit(3);
        }
    }

    @Command(name="run-client", description="Internal use only", hidden=true)
    public static class RunClientCommand
    extends LauncherCommand {
        @Arguments(description="Arguments to pass to server")
        public final List<String> args = new ArrayList<String>();

        @Override
        public void execute() {
            this.invokeMain(this.args, false);
        }
    }

    @Command(name="start-client", description="Internal use only", hidden=true)
    public static class StartClientCommand
    extends LauncherCommand {
        @Arguments(description="Arguments to pass to server")
        public final List<String> args = new ArrayList<String>();
        private static PidFile pidFile = null;

        @Override
        @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
        public void execute() {
            pidFile = new PidFile(this.pidFilePath);
            try {
                pidFile.indicateStarting();
            }
            catch (AlreadyRunningError e) {
                System.err.println(e.getMessage());
                System.exit(0);
            }
            this.invokeMain(this.args, true);
            pidFile.indicateRunning();
        }
    }

    @Command(name="run", description="Start server in foreground")
    public static class RunCommand
    extends LauncherCommand {
        @Arguments(description="Arguments to pass to server")
        public final List<String> args = new ArrayList<String>();

        @Override
        public void execute() {
            this.start(this.args, false);
        }
    }

    @Command(name="start", description="Start server")
    public static class StartCommand
    extends LauncherCommand {
        @Arguments(description="Arguments to pass to server")
        public final List<String> args = new ArrayList<String>();

        @Override
        public void execute() {
            this.start(this.args, true);
        }
    }

    static abstract class LauncherCommand
    implements Runnable {
        final String installPath;
        @Option(type=OptionType.GLOBAL, name={"-v", "--verbose"}, description="Run verbosely")
        public boolean verbose = false;
        @Option(type=OptionType.GLOBAL, name={"--node-config"}, description="Path to node properties file. Defaults to INSTALL_PATH/etc/node.properties")
        public String nodePropertiesPath = null;
        @Option(type=OptionType.GLOBAL, name={"--jvm-properties"}, description="Path to jvm configuration file. Defaults to INSTALL_PATH/etc/jvm.properties")
        public String jvmPropertiesPath = null;
        @Option(type=OptionType.GLOBAL, name={"--jvm-config"}, description="Path to legacy jvm config file. Defaults to INSTALL_PATH/etc/jvm.config")
        public String jvmConfigPath = null;
        @Option(type=OptionType.GLOBAL, name={"--config"}, description="Path to configuration file. Defaults to INSTALL_PATH/etc/config.properties")
        public String configPath = null;
        @Option(type=OptionType.GLOBAL, name={"--secrets-config"}, description="Optional path to configuration file containing secrets.")
        public String secretsConfigPath = null;
        @Option(type=OptionType.GLOBAL, name={"--data"}, description="Path to data directory. Defaults to INSTALL_PATH")
        public String dataDir = null;
        @Option(type=OptionType.GLOBAL, name={"--pid-file"}, description="Path to pid file. Defaults to DATA_DIR/var/run/launcher.pid")
        public String pidFilePath = null;
        public String legacyPidFilePath = null;
        @Option(type=OptionType.GLOBAL, name={"--log-file"}, description="Path to log file. Defaults to DATA_DIR/var/log/launcher.log")
        public String logPath = null;
        @Option(type=OptionType.GLOBAL, name={"--log-levels-file"}, description="Path to log config file. Defaults to INSTALL_PATH/etc/log.properties")
        public String logLevelsPath = null;
        @Option(type=OptionType.GLOBAL, name={"--bootstrap-log-file"}, description="Path to bootstrap log file. Defaults to DATA_DIR/var/log/bootstrap.log")
        public String bootstrapLogPath = null;
        @Option(type=OptionType.GLOBAL, name={"--audit-log-file"}, description="Path to audit log file. Defaults to DATA_DIR/var/log/audit.log")
        public String auditLogPath = null;
        @Option(type=OptionType.GLOBAL, name={"-D"}, description="Set a Java System property")
        public final List<String> property = new ArrayList<String>();
        final Properties systemProperties = new Properties();
        final List<String> launcherArgs = new ArrayList<String>();
        private int stopTimeoutSeconds = 60;

        LauncherCommand() {
            URL launcherResource = Main.class.getProtectionDomain().getCodeSource().getLocation();
            if (launcherResource == null) {
                System.err.print("Unable to get path of launcher jar\n");
                System.exit(1);
            }
            try {
                this.installPath = new File(launcherResource.toURI()).getParentFile().getParent();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            this.logLevelsPath = this.installPath + "/etc/log.properties";
            if (!new File(this.logLevelsPath).canRead() && new File(this.installPath + "/etc/log.config").canRead()) {
                System.err.print("Did not find a log.properties file, but found a log.config instead.  log.config is no longer supported, please use log.properties.");
            }
        }

        private String addKubernetesToTrustStore() {
            File certFile = new File("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt");
            if (certFile.exists() && certFile.isFile()) {
                String javaHome = System.getProperty("java.home");
                if (javaHome == null) {
                    System.out.println("System Property java.home not set.");
                    System.exit(1);
                }
                File sourceTS = new File(javaHome + "/lib/security/cacerts");
                File destinationTS = new File(this.dataDir + "/var/cacerts");
                String alias = "kubernetes-root-ca-cert";
                char[] password = "changeit".toCharArray();
                try (FileInputStream sourceIs = new FileInputStream(sourceTS);
                     FileOutputStream destinationOs = new FileOutputStream(destinationTS);
                     FileInputStream certIs = new FileInputStream(certFile);){
                    KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keystore.load(sourceIs, password);
                    BufferedInputStream bis = new BufferedInputStream(certIs);
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    Certificate cert = cf.generateCertificate(bis);
                    keystore.setCertificateEntry(alias, cert);
                    keystore.store(destinationOs, password);
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new RuntimeException("Configuring TLS TrustStore", e);
                }
                if (this.verbose) {
                    System.out.println("Created new TrustStore with Kubernetes Certificate");
                }
                return destinationTS.getAbsolutePath();
            }
            return null;
        }

        abstract void execute();

        @Override
        public final void run() {
            if (this.verbose) {
                this.launcherArgs.add("-v");
                Processes.setVerbose(true);
            }
            if (this.nodePropertiesPath == null) {
                this.nodePropertiesPath = this.installPath + "/etc/node.properties";
            } else {
                this.launcherArgs.add("--node-config");
                this.launcherArgs.add(new File(this.nodePropertiesPath).getAbsolutePath());
            }
            if (this.jvmPropertiesPath == null) {
                this.jvmPropertiesPath = this.installPath + "/etc/jvm.properties";
            } else {
                this.launcherArgs.add("--jvm-properties");
                this.launcherArgs.add(new File(this.jvmPropertiesPath).getAbsolutePath());
            }
            if (this.jvmConfigPath == null) {
                this.jvmConfigPath = this.installPath + "/etc/jvm.config";
            } else {
                this.launcherArgs.add("--jvm-config");
                this.launcherArgs.add(new File(this.jvmConfigPath).getAbsolutePath());
            }
            if (this.configPath == null) {
                this.configPath = this.installPath + "/etc/config.properties";
            } else {
                this.launcherArgs.add("--config");
                this.launcherArgs.add(new File(this.configPath).getAbsolutePath());
            }
            if (this.secretsConfigPath == null) {
                this.secretsConfigPath = this.installPath + "/etc/secrets.properties";
                if (!new File(this.secretsConfigPath).exists()) {
                    this.secretsConfigPath = null;
                }
            }
            if (this.secretsConfigPath != null) {
                this.launcherArgs.add("--secrets-config");
                this.launcherArgs.add(new File(this.secretsConfigPath).getAbsolutePath());
            }
            if (this.dataDir == null) {
                this.dataDir = this.installPath;
            } else {
                this.launcherArgs.add("--data");
                this.launcherArgs.add(new File(this.dataDir).getAbsolutePath());
            }
            this.launcherArgs.add("--log-levels-file");
            this.launcherArgs.add(new File(this.logLevelsPath).getAbsolutePath());
            try {
                FileInputStream nodeFile = new FileInputStream(this.nodePropertiesPath);
                Object object = null;
                try {
                    this.systemProperties.load(nodeFile);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (nodeFile != null) {
                        if (object != null) {
                            try {
                                ((InputStream)nodeFile).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)nodeFile).close();
                        }
                    }
                }
            }
            catch (FileNotFoundException nodeFile) {
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading node properties file: " + e);
            }
            for (String s : this.property) {
                this.launcherArgs.add("-D");
                this.launcherArgs.add(s);
                String[] split = s.split("=", 2);
                String key = split[0];
                if (key.equals("config")) {
                    System.out.println("Config can not be passed in a -D argument. Use --config instead");
                    System.exit(2);
                }
                if (key.equals("secrets-config")) {
                    System.out.println("secrets-config can not be passed in a -D argument. Use --secrets-config instead");
                    System.exit(2);
                }
                String value = "";
                if (split.length > 1) {
                    value = split[1];
                }
                this.systemProperties.setProperty(key, value);
            }
            this.dataDir = (String)MoreObjects.firstNonNull((Object)this.systemProperties.getProperty("node.data-dir"), (Object)this.dataDir);
            if (this.pidFilePath == null) {
                this.pidFilePath = this.dataDir + "/var/run/platform.pid";
                this.legacyPidFilePath = this.dataDir + "/var/run/launcher.pid";
            } else {
                this.launcherArgs.add("--pid-file");
                this.launcherArgs.add(new File(this.pidFilePath).getAbsolutePath());
            }
            if (this.logPath == null) {
                this.logPath = this.dataDir + "/var/log/launcher.log";
            } else {
                this.launcherArgs.add("--log-file");
                this.launcherArgs.add(new File(this.logPath).getAbsolutePath());
            }
            if (this.auditLogPath == null) {
                this.auditLogPath = this.dataDir + "/var/log/audit.log";
            } else {
                this.launcherArgs.add("--audit-log-file");
                this.launcherArgs.add(new File(this.auditLogPath).getAbsolutePath());
            }
            if (this.bootstrapLogPath == null) {
                this.bootstrapLogPath = this.dataDir + "/var/log/bootstrap.log";
            } else {
                this.launcherArgs.add("--bootstrap-log-file");
                this.launcherArgs.add(new File(this.bootstrapLogPath).getAbsolutePath());
            }
            String stopTimeoutString = this.systemProperties.getProperty("launcher.stop-timeout-seconds");
            if (stopTimeoutString != null) {
                try {
                    this.stopTimeoutSeconds = Integer.parseUnsignedInt(stopTimeoutString);
                    if (this.stopTimeoutSeconds == 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    System.out.println("Value of launcher.stop-timeout-seconds property not a positive integer");
                    System.exit(2);
                }
            }
            if (this.verbose) {
                for (String key : this.systemProperties.stringPropertyNames()) {
                    System.out.println(key + "=" + this.systemProperties.getProperty(key));
                }
            }
            this.execute();
        }

        @SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="false positive")
        protected void start(List<String> args, boolean daemon) {
            Object trustStorePath;
            Serializable jvmProperties;
            if ("root".equals(System.getProperty("user.name"))) {
                System.err.println("Cannot run as root");
                System.exit(1);
            }
            PidFile pidFile = new PidFile(this.pidFilePath);
            PidStatus pidStatus = pidFile.getStatus();
            if (pidStatus.held) {
                String msg = "Already running";
                if (pidStatus.pid != 0) {
                    msg = msg + " as " + pidStatus.pid;
                }
                System.err.println(msg);
                System.exit(0);
            }
            if (!new File(this.configPath).exists()) {
                System.err.println("Config file is missing: " + this.configPath);
                System.exit(6);
            }
            if (this.secretsConfigPath != null && !new File(this.secretsConfigPath).exists()) {
                System.err.println("Secrets Config file is missing: " + this.secretsConfigPath);
                System.exit(6);
            }
            ArrayList<String> jvmConfigArgs = new ArrayList<String>();
            try (FileInputStream jvmPropertiesFile = new FileInputStream(this.jvmPropertiesPath);){
                jvmProperties = new Properties();
                ((Properties)jvmProperties).load(jvmPropertiesFile);
                for (Map.Entry<Object, Object> entry : ((Properties)jvmProperties).entrySet()) {
                    if ("-classpath".equals(entry.getKey())) {
                        jvmConfigArgs.add(entry.getKey().toString());
                        jvmConfigArgs.add(entry.getValue().toString());
                        continue;
                    }
                    jvmConfigArgs.add(entry.getKey().toString() + entry.getValue().toString());
                }
            }
            catch (FileNotFoundException ignore) {
                try {
                    BufferedReader jvmReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.jvmConfigPath), StandardCharsets.UTF_8));
                    jvmProperties = null;
                    try {
                        String line;
                        boolean allowSpaces = false;
                        while ((line = jvmReader.readLine()) != null) {
                            if (!line.matches("\\s*(?:#.*)?")) {
                                line = line.trim();
                                if (!allowSpaces && line.matches(".*[ '\"\\\\].*")) {
                                    System.err.println("JVM config file line contains space or other shell metacharacter: " + line);
                                    System.err.println("JVM config file format is one argument per line, no shell quoting.");
                                    System.err.println("To indicate you know what you're doing, add before this line the comment line:");
                                    System.err.println("# allow spaces");
                                    System.exit(1);
                                }
                                jvmConfigArgs.add(line);
                                continue;
                            }
                            if (!line.matches("(?i)\\s*#\\s*allow\\s+spaces\\s*")) continue;
                            allowSpaces = true;
                        }
                    }
                    catch (Throwable line) {
                        jvmProperties = line;
                        throw line;
                    }
                    finally {
                        if (jvmReader != null) {
                            if (jvmProperties != null) {
                                try {
                                    jvmReader.close();
                                }
                                catch (Throwable line) {
                                    ((Throwable)jvmProperties).addSuppressed(line);
                                }
                            } else {
                                jvmReader.close();
                            }
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    System.err.println("JVM config file is missing: " + this.jvmConfigPath);
                    System.exit(6);
                }
                catch (IOException e) {
                    System.err.println("Error reading JVM config file: " + e);
                    System.exit(6);
                }
            }
            catch (IOException e) {
                System.err.println("Error reading JVM properties file: " + e);
                System.exit(6);
            }
            boolean isJava8 = System.getProperty("java.version").startsWith("1.8.");
            boolean gcSpecified = jvmConfigArgs.stream().anyMatch(arg -> arg.equals("-XX:+UseG1GC") || arg.equals("-XX:+UseParallelGC") || arg.equals("-XX:+UseConcMarkSweepGC"));
            ArrayList<String> javaArgs = new ArrayList<String>();
            javaArgs.add("java");
            if (isJava8 && !gcSpecified) {
                javaArgs.add("-XX:+UseConcMarkSweepGC");
                javaArgs.add("-XX:+ExplicitGCInvokesConcurrent");
            }
            javaArgs.add("-XX:+HeapDumpOnOutOfMemoryError");
            javaArgs.add("-XX:HeapDumpPath=var");
            if (isJava8) {
                javaArgs.add("-XX:+AggressiveOpts");
            }
            if (jvmConfigArgs.stream().noneMatch(s -> s.startsWith("-XX:OnOutOfMemoryError=") || "-XX:CrashOnOutOfMemoryError".equals(s))) {
                javaArgs.add("-XX:+ExitOnOutOfMemoryError");
            }
            javaArgs.add("-Djava.util.logging.manager=com.proofpoint.log.ShutdownWaitingLogManager");
            if (this.launcherArgs.stream().noneMatch(s -> s.startsWith("-Djavax.net.ssl.trustStore=")) && (trustStorePath = this.addKubernetesToTrustStore()) != null) {
                javaArgs.add("-Djavax.net.ssl.trustStore=" + (String)trustStorePath);
            }
            javaArgs.addAll(jvmConfigArgs);
            if (isJava8 && jvmConfigArgs.stream().noneMatch(s -> s.startsWith("-Xmx"))) {
                if (jvmConfigArgs.stream().noneMatch(s -> s.equals("-XX:+UnlockExperimentalVMOptions"))) {
                    javaArgs.add("-XX:+UnlockExperimentalVMOptions");
                }
                if (jvmConfigArgs.stream().noneMatch(s -> s.equals("-XX:+UseCGroupMemoryLimitForHeap"))) {
                    javaArgs.add("-XX:+UseCGroupMemoryLimitForHeap");
                }
            }
            for (String key : this.systemProperties.stringPropertyNames()) {
                javaArgs.add("-D" + key + "=" + this.systemProperties.getProperty(key));
            }
            javaArgs.add("-Dconfig=" + this.configPath);
            if (this.secretsConfigPath != null) {
                javaArgs.add("-Dsecrets-config=" + this.secretsConfigPath);
            }
            if (daemon) {
                javaArgs.add("-Dlog.path=" + this.logPath);
                javaArgs.add("-Dlog.enable-console=false");
            }
            if (new File(this.logLevelsPath).exists()) {
                javaArgs.add("-Dlog.levels-file=" + this.logLevelsPath);
            }
            javaArgs.add("-Daudit.log.path=" + this.auditLogPath);
            javaArgs.add("-Dlog.bootstrap.path=" + this.bootstrapLogPath);
            javaArgs.add("-jar");
            javaArgs.add(this.installPath + "/lib/launcher.jar");
            javaArgs.addAll(this.launcherArgs);
            if (daemon) {
                this.checkLibraryPath(javaArgs);
                javaArgs.add("start-client");
            } else {
                javaArgs.add("run-client");
            }
            javaArgs.addAll(args);
            if (this.verbose) {
                System.out.println(Joiner.on((char)' ').join(javaArgs));
            }
            Process child = null;
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(javaArgs).directory(new File(this.dataDir)).redirectInput(Processes.NULL_FILE);
                processBuilder = daemon ? processBuilder.redirectOutput(Processes.NULL_FILE).redirectError(Processes.NULL_FILE) : processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
                child = processBuilder.start();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
            if (!daemon) {
                Process childCopy = child;
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    childCopy.destroy();
                    try {
                        childCopy.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }));
                try {
                    System.exit(child.waitFor());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            do {
                try {
                    int status = child.exitValue();
                    if (status == 0) {
                        status = 1;
                    }
                    System.err.println("Failed to start");
                    System.exit(status);
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    // empty catch block
                }
                pidStatus = pidFile.waitRunning();
                if (pidStatus.held) continue;
                if (this.verbose) {
                    System.out.println("Waiting for child to lock pid file");
                }
                LockSupport.parkNanos(100000000L);
            } while (!pidStatus.held);
            System.out.println("Started as " + pidStatus.pid);
            System.exit(0);
        }

        private void checkLibraryPath(List<String> javaArgs) {
            String pathArg = javaArgs.stream().filter(arg -> arg.startsWith("-Djava.library.path=")).reduce((a, b) -> b).orElse(null);
            if (pathArg == null) {
                return;
            }
            String defaultPath = System.getProperty("java.library.path", "");
            if (pathArg.contains(defaultPath)) {
                return;
            }
            System.out.printf("WARNING: The java.library.path property is being set to a value that does not%ncontain the default library path. This is likely to cause a failure to start.%nThe default path is %s%n", defaultPath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="false positive")
        protected void invokeMain(List<String> args, boolean daemon) {
            String mainClassName;
            if (!this.installPath.equals(this.dataDir)) {
                try {
                    Files.delete(Paths.get(this.dataDir, "etc"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    Files.createSymbolicLink(Paths.get(this.dataDir, "etc"), Paths.get(this.installPath, "etc"), new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ZipFile jarFile = null;
            try {
                Manifest manifest = null;
                try {
                    jarFile = new JarFile(this.installPath + "/lib/main.jar");
                    manifest = ((JarFile)jarFile).getManifest();
                }
                catch (IOException e) {
                    System.err.println("Unable to open main jar manifest: " + e + "\n");
                    System.exit(1);
                }
                if (manifest == null) {
                    System.err.println("Manifest missing from main jar");
                    System.exit(1);
                }
                if ((mainClassName = manifest.getMainAttributes().getValue("Main-Class")) == null) {
                    System.err.println("Unable to get Main-Class attribute from main jar manifest");
                    System.exit(1);
                }
            }
            finally {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                }
                catch (IOException manifest) {}
            }
            Class<?> mainClass = null;
            try {
                mainClass = Class.forName(mainClassName);
            }
            catch (ClassNotFoundException e) {
                System.err.println("Unable to load class " + mainClassName + ": " + e);
                System.exit(1);
            }
            Method mainClassMethod = null;
            try {
                mainClassMethod = mainClass.getMethod("main", String[].class);
            }
            catch (NoSuchMethodException e) {
                System.err.println("Unable to find main method: " + e);
                System.exit(1);
            }
            String mainVersion = mainClass.getPackage().getImplementationVersion();
            if (mainVersion != null) {
                System.setProperty("launcher.main.version", mainVersion);
            }
            if (daemon) {
                Processes.detach();
            }
            try {
                mainClassMethod.invoke(null, new Object[]{args.toArray(new String[0])});
            }
            catch (Throwable e) {
                System.err.println("Main method " + mainClassMethod.getDeclaringClass() + "." + mainClassMethod.getName() + " threw " + e);
                System.exit(1);
            }
        }

        KillStatus killProcess(boolean graceful) {
            PidStatusSource pidFile = new PidFile(this.pidFilePath);
            for (int pidTriesLeft = 10; pidTriesLeft > 0; --pidTriesLeft) {
                PidStatus pidStatus = pidFile.getStatus();
                if (!pidStatus.held) {
                    if (this.legacyPidFilePath != null) {
                        pidFile = new LegacyPidFile(this.legacyPidFilePath);
                        this.legacyPidFilePath = null;
                        continue;
                    }
                    return new KillStatus(0, "Not running\n");
                }
                if (pidStatus.pid != 0) {
                    int pid = pidStatus.pid;
                    Processes.kill(pid, graceful);
                    for (int waitTriesLeft = this.stopTimeoutSeconds * 10; waitTriesLeft > 0; --waitTriesLeft) {
                        pidStatus = pidFile.getStatus();
                        if (!pidStatus.held || pidStatus.pid != pid) {
                            return new KillStatus(0, (graceful ? "Stopped " : "Killed ") + pid + "\n");
                        }
                        if (waitTriesLeft == 1 && graceful) {
                            waitTriesLeft = 10;
                            graceful = false;
                            Processes.kill(pid, graceful);
                        }
                        LockSupport.parkNanos(100000000L);
                    }
                    return new KillStatus(1, "Process " + pid + " refuses to die\n");
                }
                LockSupport.parkNanos(100000000L);
            }
            return new KillStatus(1, "Unable to get server pid\n");
        }

        static class KillStatus {
            public final int exitCode;
            public final String msg;

            public KillStatus(int exitCode, String msg) {
                this.exitCode = exitCode;
                this.msg = Objects.requireNonNull(msg, "msg is null");
            }
        }
    }
}

