/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.launcher;

import com.proofpoint.launcher.AlreadyRunningError;
import com.proofpoint.launcher.PidStatus;
import com.proofpoint.launcher.PidStatusSource;
import com.proofpoint.launcher.Processes;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.locks.LockSupport;

class PidFile
implements PidStatusSource {
    private static final int STARTING = 1;
    private static final int RUNNING = 7;
    private static final int NOT_YET_RUNNING = 10;
    private FileChannel pidChannel = null;
    private FileChannel lockChannel = null;
    private FileLock startLock = null;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private FileLock runningLock = null;
    private FileLock notYetRunningLock = null;

    PidFile(String pidFilePath) {
        Objects.requireNonNull(pidFilePath, "pidFilePath is null");
        if (!new File(pidFilePath).getParentFile().mkdirs()) {
            // empty if block
        }
        try {
            this.pidChannel = new RandomAccessFile(pidFilePath, "rw").getChannel();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot open pid file: " + e);
        }
        if (System.getProperty("os.name").startsWith("Windows")) {
            try {
                this.lockChannel = new RandomAccessFile(pidFilePath + ".lck", "rw").getChannel();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Cannot open pid lockfile: " + e);
            }
        } else {
            this.lockChannel = this.pidChannel;
        }
    }

    void indicateStarting() throws AlreadyRunningError {
        try {
            this.startLock = this.lockChannel.tryLock(0L, 1L, false);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot lock pid file: " + e);
        }
        if (this.startLock == null) {
            throw new AlreadyRunningError(this.readPid());
        }
        try {
            this.pidChannel.truncate(0L);
            this.pidChannel.write(ByteBuffer.wrap((Integer.toString(Processes.getpid()) + "\n").getBytes(StandardCharsets.US_ASCII)));
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot write to pid file: " + e);
        }
        try {
            this.notYetRunningLock = this.lockChannel.lock(9L, 1L, false);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot lock pid file: " + e);
        }
    }

    @SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="false positive")
    private int readPid() {
        for (int i = 0; i < 10; ++i) {
            try {
                this.pidChannel.position(0L);
                String line = new BufferedReader(Channels.newReader((ReadableByteChannel)this.pidChannel, "us-ascii")).readLine();
                if (line != null) {
                    return Integer.decode(line);
                }
            }
            catch (IOException | NumberFormatException e) {
                throw new RuntimeException("Cannot read pid file: " + e);
            }
            LockSupport.parkNanos(10000000L);
        }
        return 0;
    }

    void indicateRunning() {
        try {
            this.runningLock = this.lockChannel.lock(1L, 6L, false);
            this.notYetRunningLock.release();
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot lock pid file: " + e);
        }
        this.notYetRunningLock = null;
    }

    @Override
    public PidStatus getStatus() {
        FileLock fileLock;
        try {
            fileLock = this.lockChannel.tryLock(1L, 9L, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot lock pid file: " + e);
        }
        return this.getPidStatus(fileLock);
    }

    public PidStatus getRunning() {
        FileLock fileLock;
        try {
            fileLock = this.lockChannel.tryLock(1L, 6L, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot lock pid file: " + e);
        }
        return this.getPidStatus(fileLock);
    }

    private PidStatus getPidStatus(FileLock fileLock) {
        if (fileLock == null) {
            return PidStatus.heldBy(this.readPid());
        }
        try {
            fileLock.release();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return PidStatus.notHeld();
    }

    PidStatus waitRunning() {
        FileLock fileLock;
        try {
            fileLock = this.lockChannel.lock(9L, 1L, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot lock pid file: " + e);
        }
        try {
            fileLock.release();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            fileLock = this.lockChannel.tryLock(1L, 6L, true);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot lock pid file: " + e);
        }
        return this.getPidStatus(fileLock);
    }
}

