/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.launcher;

import com.google.common.collect.ImmutableList;
import com.proofpoint.launcher.internal.jnr.constants.platform.Errno;
import com.proofpoint.launcher.internal.jnr.posix.POSIX;
import com.proofpoint.launcher.internal.jnr.posix.POSIXFactory;
import com.proofpoint.launcher.internal.jnr.posix.POSIXHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Signal;

class Processes {
    private static final OurPOSIXHandler posixHandler = new OurPOSIXHandler();
    public static final File NULL_FILE = System.getProperty("os.name").startsWith("Windows") ? new File("NUL") : new File("/dev/null");

    private Processes() {
    }

    static int getpid() {
        return Processes.getPosix().getpid();
    }

    static void detach() {
        if (!System.getProperty("os.name").startsWith("Windows")) {
            Processes.getPosix().setsid();
        }
    }

    static void kill(int pid, boolean graceful) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            ImmutableList args = ImmutableList.of((Object)"taskkill", (Object)"/f", (Object)"/pid", (Object)Integer.toString(pid));
            try {
                new ProcessBuilder((List<String>)args).redirectInput(ProcessBuilder.Redirect.from(NULL_FILE)).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).start().waitFor();
            }
            catch (IOException | InterruptedException exception) {}
        } else {
            int signal = new Signal(graceful ? "TERM" : "KILL").getNumber();
            Processes.getPosix().kill(pid, signal);
        }
    }

    public static boolean exists(int pid) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return false;
        }
        return Processes.getPosix().kill(pid, 0) == 0;
    }

    public static void setVerbose(boolean verbose) {
        posixHandler.setVerbose(verbose);
    }

    private static POSIX getPosix() {
        return PosixSingletonHolder.instance;
    }

    static /* synthetic */ OurPOSIXHandler access$200() {
        return posixHandler;
    }

    private static final class OurPOSIXHandler
    implements POSIXHandler {
        private final AtomicBoolean verbose = new AtomicBoolean(false);

        private OurPOSIXHandler() {
        }

        void setVerbose(boolean verbose) {
            this.verbose.set(verbose);
        }

        @Override
        public void error(Errno error, String extraData) {
            throw new RuntimeException("native error " + error.description() + " " + extraData);
        }

        @Override
        public void error(Errno errno, String extraData1, String extraData2) {
            throw new RuntimeException("native error " + errno.description() + " " + extraData1 + " " + extraData2);
        }

        @Override
        public void unimplementedError(String methodName) {
            throw new IllegalStateException(methodName + " is not implemented in jnr-posix");
        }

        @Override
        public void warn(POSIXHandler.WARNING_ID id, String message, Object ... data) {
            String msg;
            try {
                msg = String.format(message, data);
            }
            catch (IllegalFormatException e) {
                msg = message + " " + Arrays.toString(data);
            }
            Logger.getLogger("com.proofpoint.launcher.internal.jnr-posix").log(Level.WARNING, msg);
        }

        @Override
        public boolean isVerbose() {
            return this.verbose.get();
        }

        @Override
        public File getCurrentWorkingDirectory() {
            return new File(".");
        }

        @Override
        public String[] getEnv() {
            String[] envp = new String[System.getenv().size()];
            int i = 0;
            for (Map.Entry<String, String> pair : System.getenv().entrySet()) {
                envp[i++] = pair.getKey() + "=" + pair.getValue();
            }
            return envp;
        }

        @Override
        public InputStream getInputStream() {
            return System.in;
        }

        @Override
        public PrintStream getOutputStream() {
            return System.out;
        }

        @Override
        public int getPID() {
            throw new IllegalStateException("getPID is not implemented in jnr-posix");
        }

        @Override
        public PrintStream getErrorStream() {
            return System.err;
        }
    }

    private static class PosixSingletonHolder {
        private static final POSIX instance = POSIXFactory.getNativePOSIX(Processes.access$200());

        private PosixSingletonHolder() {
        }
    }
}

