/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.launcher.internal.asm.commons;

import com.proofpoint.launcher.internal.asm.AnnotationVisitor;
import com.proofpoint.launcher.internal.asm.Label;
import com.proofpoint.launcher.internal.asm.MethodVisitor;
import com.proofpoint.launcher.internal.asm.Opcodes;
import com.proofpoint.launcher.internal.asm.Type;
import com.proofpoint.launcher.internal.asm.TypePath;

public class LocalVariablesSorter
extends MethodVisitor {
    private static final Type OBJECT_TYPE;
    private int[] mapping = new int[40];
    private Object[] newLocals = new Object[20];
    protected final int firstLocal;
    protected int nextLocal;
    private boolean changed;
    static /* synthetic */ Class class$org$objectweb$asm$commons$LocalVariablesSorter;

    public LocalVariablesSorter(int n, String string, MethodVisitor methodVisitor) {
        this(327680, n, string, methodVisitor);
        if (this.getClass() != class$org$objectweb$asm$commons$LocalVariablesSorter) {
            throw new IllegalStateException();
        }
    }

    protected LocalVariablesSorter(int n, int n2, String string, MethodVisitor methodVisitor) {
        super(n, methodVisitor);
        Type[] typeArray = Type.getArgumentTypes(string);
        this.nextLocal = (8 & n2) == 0 ? 1 : 0;
        for (int i = 0; i < typeArray.length; ++i) {
            this.nextLocal += typeArray[i].getSize();
        }
        this.firstLocal = this.nextLocal;
    }

    public void visitVarInsn(int n, int n2) {
        Type type;
        switch (n) {
            case 22: 
            case 55: {
                type = Type.LONG_TYPE;
                break;
            }
            case 24: 
            case 57: {
                type = Type.DOUBLE_TYPE;
                break;
            }
            case 23: 
            case 56: {
                type = Type.FLOAT_TYPE;
                break;
            }
            case 21: 
            case 54: {
                type = Type.INT_TYPE;
                break;
            }
            default: {
                type = OBJECT_TYPE;
            }
        }
        this.mv.visitVarInsn(n, this.remap(n2, type));
    }

    public void visitIincInsn(int n, int n2) {
        this.mv.visitIincInsn(this.remap(n, Type.INT_TYPE), n2);
    }

    public void visitMaxs(int n, int n2) {
        this.mv.visitMaxs(n, this.nextLocal);
    }

    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        int n2 = this.remap(n, Type.getType(string2));
        this.mv.visitLocalVariable(string, string2, string3, label, label2, n2);
    }

    public AnnotationVisitor visitLocalVariableAnnotation(int n, TypePath typePath, Label[] labelArray, Label[] labelArray2, int[] nArray, String string, boolean bl) {
        Type type = Type.getType(string);
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = this.remap(nArray[i], type);
        }
        return this.mv.visitLocalVariableAnnotation(n, typePath, labelArray, labelArray2, nArray2, string, bl);
    }

    public void visitFrame(int n, int n2, Object[] objectArray, int n3, Object[] objectArray2) {
        int n4;
        if (n != -1) {
            throw new IllegalStateException("ClassReader.accept() should be called with EXPAND_FRAMES flag");
        }
        if (!this.changed) {
            this.mv.visitFrame(n, n2, objectArray, n3, objectArray2);
            return;
        }
        Object[] objectArray3 = new Object[this.newLocals.length];
        System.arraycopy(this.newLocals, 0, objectArray3, 0, objectArray3.length);
        this.updateNewLocals(this.newLocals);
        int n5 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            int n6;
            Object object = objectArray[n4];
            int n7 = n6 = object == Opcodes.LONG || object == Opcodes.DOUBLE ? 2 : 1;
            if (object != Opcodes.TOP) {
                Type type = OBJECT_TYPE;
                if (object == Opcodes.INTEGER) {
                    type = Type.INT_TYPE;
                } else if (object == Opcodes.FLOAT) {
                    type = Type.FLOAT_TYPE;
                } else if (object == Opcodes.LONG) {
                    type = Type.LONG_TYPE;
                } else if (object == Opcodes.DOUBLE) {
                    type = Type.DOUBLE_TYPE;
                } else if (object instanceof String) {
                    type = Type.getObjectType((String)object);
                }
                this.setFrameLocal(this.remap(n5, type), object);
            }
            n5 += n6;
        }
        n5 = 0;
        n4 = 0;
        int n8 = 0;
        while (n5 < this.newLocals.length) {
            Object object;
            if ((object = this.newLocals[n5++]) != null && object != Opcodes.TOP) {
                this.newLocals[n8] = object;
                n4 = n8 + 1;
                if (object == Opcodes.LONG || object == Opcodes.DOUBLE) {
                    ++n5;
                }
            } else {
                this.newLocals[n8] = Opcodes.TOP;
            }
            ++n8;
        }
        this.mv.visitFrame(n, n4, this.newLocals, n3, objectArray2);
        this.newLocals = objectArray3;
    }

    public int newLocal(Type type) {
        Object object;
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                object = Opcodes.INTEGER;
                break;
            }
            case 6: {
                object = Opcodes.FLOAT;
                break;
            }
            case 7: {
                object = Opcodes.LONG;
                break;
            }
            case 8: {
                object = Opcodes.DOUBLE;
                break;
            }
            case 9: {
                object = type.getDescriptor();
                break;
            }
            default: {
                object = type.getInternalName();
            }
        }
        int n = this.newLocalMapping(type);
        this.setLocalType(n, type);
        this.setFrameLocal(n, object);
        this.changed = true;
        return n;
    }

    protected void updateNewLocals(Object[] objectArray) {
    }

    protected void setLocalType(int n, Type type) {
    }

    private void setFrameLocal(int n, Object object) {
        int n2 = this.newLocals.length;
        if (n >= n2) {
            Object[] objectArray = new Object[Math.max(2 * n2, n + 1)];
            System.arraycopy(this.newLocals, 0, objectArray, 0, n2);
            this.newLocals = objectArray;
        }
        this.newLocals[n] = object;
    }

    private int remap(int n, Type type) {
        int n2;
        int n3;
        if (n + type.getSize() <= this.firstLocal) {
            return n;
        }
        int n4 = 2 * n + type.getSize() - 1;
        if (n4 >= (n3 = this.mapping.length)) {
            int[] nArray = new int[Math.max(2 * n3, n4 + 1)];
            System.arraycopy(this.mapping, 0, nArray, 0, n3);
            this.mapping = nArray;
        }
        if ((n2 = this.mapping[n4]) == 0) {
            n2 = this.newLocalMapping(type);
            this.setLocalType(n2, type);
            this.mapping[n4] = n2 + 1;
        } else {
            --n2;
        }
        if (n2 != n) {
            this.changed = true;
        }
        return n2;
    }

    protected int newLocalMapping(Type type) {
        int n = this.nextLocal;
        this.nextLocal += type.getSize();
        return n;
    }

    static {
        LocalVariablesSorter._clinit_();
        OBJECT_TYPE = Type.getObjectType("java/lang/Object");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string2 = classNotFoundException.getMessage();
            throw new NoClassDefFoundError(string2);
        }
    }

    private static void _clinit_() {
        class$org$objectweb$asm$commons$LocalVariablesSorter = LocalVariablesSorter.class$("com.proofpoint.launcher.internal.asm.commons.LocalVariablesSorter");
    }
}

