/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.launcher.internal.jnr.ffi;

import com.proofpoint.launcher.internal.jnr.ffi.NativeType;
import com.proofpoint.launcher.internal.jnr.ffi.ObjectReferenceManager;
import com.proofpoint.launcher.internal.jnr.ffi.Type;
import com.proofpoint.launcher.internal.jnr.ffi.TypeAlias;
import com.proofpoint.launcher.internal.jnr.ffi.provider.ClosureManager;
import com.proofpoint.launcher.internal.jnr.ffi.provider.FFIProvider;
import com.proofpoint.launcher.internal.jnr.ffi.provider.LoadedLibrary;
import com.proofpoint.launcher.internal.jnr.ffi.provider.MemoryManager;
import java.nio.ByteOrder;

public abstract class Runtime {
    public static Runtime getSystemRuntime() {
        return SingletonHolder.SYSTEM_RUNTIME;
    }

    public static Runtime getRuntime(Object library) {
        return ((LoadedLibrary)library).getRuntime();
    }

    public abstract Type findType(NativeType var1);

    public abstract Type findType(TypeAlias var1);

    public abstract MemoryManager getMemoryManager();

    public abstract ClosureManager getClosureManager();

    public abstract <T> ObjectReferenceManager<T> newObjectReferenceManager();

    public abstract int getLastError();

    public abstract void setLastError(int var1);

    public abstract long addressMask();

    public abstract int addressSize();

    public abstract int longSize();

    public abstract ByteOrder byteOrder();

    public abstract boolean isCompatible(Runtime var1);

    private static final class SingletonHolder {
        public static final Runtime SYSTEM_RUNTIME = FFIProvider.getSystemProvider().getRuntime();

        private SingletonHolder() {
        }
    }
}

