/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.launcher.internal.jnr.ffi.provider.jffi;

import com.kenai.jffi.Function;
import com.proofpoint.launcher.internal.asm.ClassReader;
import com.proofpoint.launcher.internal.asm.ClassVisitor;
import com.proofpoint.launcher.internal.asm.ClassWriter;
import com.proofpoint.launcher.internal.jnr.ffi.CallingConvention;
import com.proofpoint.launcher.internal.jnr.ffi.LibraryOption;
import com.proofpoint.launcher.internal.jnr.ffi.Runtime;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.CachingTypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.CompositeTypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.DefaultSignatureType;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.FromNativeContext;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.FunctionMapper;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.MethodResultContext;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.SignatureTypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.SignatureTypeMapperAdapter;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.TypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.provider.IdentityFunctionMapper;
import com.proofpoint.launcher.internal.jnr.ffi.provider.InterfaceScanner;
import com.proofpoint.launcher.internal.jnr.ffi.provider.NativeFunction;
import com.proofpoint.launcher.internal.jnr.ffi.provider.NativeVariable;
import com.proofpoint.launcher.internal.jnr.ffi.provider.NullTypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.provider.ParameterType;
import com.proofpoint.launcher.internal.jnr.ffi.provider.ResultType;
import com.proofpoint.launcher.internal.jnr.ffi.provider.SigType;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.AbstractAsmLibraryInterface;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.AnnotationTypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.AsmBuilder;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.AsmClassLoader;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.AsmRuntime;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.AsmUtil;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.BufferMethodGenerator;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.CodegenUtils;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.FastIntMethodGenerator;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.FastLongMethodGenerator;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.FastNumericMethodGenerator;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.InvokerTypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.InvokerUtil;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.LibraryLoader;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.MethodGenerator;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NativeClosureManager;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NativeFunctionMapperContext;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NativeLibrary;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NativeLibraryLoader;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NativeRuntime;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NoTrace;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NoX86;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NotImplMethodGenerator;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.SkinnyMethodAdapter;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.StubCompiler;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.SymbolNotFoundError;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.VariableAccessorGenerator;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.X86MethodGenerator;
import com.proofpoint.launcher.internal.jnr.ffi.util.Annotations;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class AsmLibraryLoader
extends LibraryLoader {
    public static final boolean DEBUG = Boolean.getBoolean("com.proofpoint.launcher.internal.jnr.ffi.compile.dump");
    private static final AtomicLong nextClassID = new AtomicLong(0L);
    private static final AtomicLong uniqueId = new AtomicLong(0L);
    private static final ThreadLocal<AsmClassLoader> classLoader = new ThreadLocal();
    private final NativeRuntime runtime = NativeRuntime.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> T loadLibrary(NativeLibrary library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        AsmClassLoader oldClassLoader = classLoader.get();
        if (oldClassLoader == null) {
            classLoader.set(new AsmClassLoader(interfaceClass.getClassLoader()));
        }
        try {
            T t = this.generateInterfaceImpl(library, interfaceClass, libraryOptions, classLoader.get());
            return t;
        }
        finally {
            if (oldClassLoader == null) {
                classLoader.remove();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T generateInterfaceImpl(NativeLibrary library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions, AsmClassLoader classLoader) {
        SignatureTypeMapper typeMapper;
        FunctionMapper functionMapper;
        boolean debug = DEBUG && !interfaceClass.isAnnotationPresent(NoTrace.class);
        ClassWriter cw = new ClassWriter(2);
        ClassVisitor cv = debug ? AsmUtil.newCheckClassAdapter(cw) : cw;
        AsmBuilder builder = new AsmBuilder(this.runtime, CodegenUtils.p(interfaceClass) + "$jnr$ffi$" + nextClassID.getAndIncrement(), cv, classLoader);
        cv.visit(50, 17, builder.getClassNamePath(), null, CodegenUtils.p(AbstractAsmLibraryInterface.class), new String[]{CodegenUtils.p(interfaceClass)});
        FunctionMapper functionMapper2 = functionMapper = libraryOptions.containsKey((Object)LibraryOption.FunctionMapper) ? (FunctionMapper)libraryOptions.get((Object)LibraryOption.FunctionMapper) : IdentityFunctionMapper.getInstance();
        if (libraryOptions.containsKey((Object)LibraryOption.TypeMapper)) {
            Object tm = libraryOptions.get((Object)LibraryOption.TypeMapper);
            if (tm instanceof SignatureTypeMapper) {
                typeMapper = (SignatureTypeMapper)tm;
            } else {
                if (!(tm instanceof TypeMapper)) throw new IllegalArgumentException("TypeMapper option is not a valid TypeMapper instance");
                typeMapper = new SignatureTypeMapperAdapter((TypeMapper)tm);
            }
        } else {
            typeMapper = new NullTypeMapper();
        }
        typeMapper = new CompositeTypeMapper(typeMapper, new CachingTypeMapper(new InvokerTypeMapper(new NativeClosureManager(this.runtime, typeMapper, classLoader), classLoader, NativeLibraryLoader.ASM_ENABLED)), new CachingTypeMapper(new AnnotationTypeMapper()));
        CallingConvention libraryCallingConvention = InvokerUtil.getCallingConvention(interfaceClass, libraryOptions);
        StubCompiler compiler = StubCompiler.newCompiler(this.runtime);
        MethodGenerator[] generators = new MethodGenerator[]{!interfaceClass.isAnnotationPresent(NoX86.class) ? new X86MethodGenerator(compiler) : new NotImplMethodGenerator(), new FastIntMethodGenerator(), new FastLongMethodGenerator(), new FastNumericMethodGenerator(), new BufferMethodGenerator()};
        InterfaceScanner scanner = new InterfaceScanner(interfaceClass, typeMapper, libraryCallingConvention);
        block6: for (NativeFunction function : scanner.functions()) {
            String functionName = functionMapper.mapFunctionName(function.name(), new NativeFunctionMapperContext(library, function.annotations()));
            try {
                long functionAddress = library.findSymbolAddress(functionName);
                MethodResultContext resultContext = new MethodResultContext(this.runtime, function.getMethod());
                DefaultSignatureType signatureType = DefaultSignatureType.create(function.getMethod().getReturnType(), resultContext);
                ResultType resultType = InvokerUtil.getResultType((Runtime)this.runtime, function.getMethod().getReturnType(), resultContext.getAnnotations(), typeMapper.getFromNativeType(signatureType, resultContext), (FromNativeContext)resultContext);
                SigType[] parameterTypes = InvokerUtil.getParameterTypes(this.runtime, typeMapper, function.getMethod());
                Function jffiFunction = new Function(functionAddress, InvokerUtil.getCallContext(resultType, parameterTypes, function.convention(), function.isErrnoRequired()));
                for (MethodGenerator g : generators) {
                    if (!g.isSupported(resultType, (ParameterType[])parameterTypes, function.convention())) continue;
                    g.generate(builder, function.getMethod().getName(), jffiFunction, resultType, (ParameterType[])parameterTypes, !function.isErrnoRequired());
                    continue block6;
                }
            }
            catch (SymbolNotFoundError ex) {
                String errorFieldName = "error_" + uniqueId.incrementAndGet();
                cv.visitField(26, errorFieldName, CodegenUtils.ci(String.class), null, ex.getMessage());
                this.generateFunctionNotFound(cv, builder.getClassNamePath(), errorFieldName, functionName, function.getMethod().getReturnType(), function.getMethod().getParameterTypes());
            }
        }
        VariableAccessorGenerator variableAccessorGenerator = new VariableAccessorGenerator(this.runtime);
        for (NativeVariable v : scanner.variables()) {
            Method m = v.getMethod();
            Type variableType = ((ParameterizedType)m.getGenericReturnType()).getActualTypeArguments()[0];
            if (!(variableType instanceof Class)) {
                throw new IllegalArgumentException("unsupported variable class: " + variableType);
            }
            String functionName = functionMapper.mapFunctionName(m.getName(), null);
            try {
                variableAccessorGenerator.generate(builder, interfaceClass, m.getName(), library.findSymbolAddress(functionName), (Class)variableType, Annotations.sortedAnnotationCollection(m.getAnnotations()), typeMapper, classLoader);
            }
            catch (SymbolNotFoundError ex) {
                String errorFieldName = "error_" + uniqueId.incrementAndGet();
                cv.visitField(26, errorFieldName, CodegenUtils.ci(String.class), null, ex.getMessage());
                this.generateFunctionNotFound(cv, builder.getClassNamePath(), errorFieldName, functionName, m.getReturnType(), m.getParameterTypes());
            }
        }
        SkinnyMethodAdapter init = new SkinnyMethodAdapter(cv, 1, "<init>", CodegenUtils.sig(Void.TYPE, Runtime.class, NativeLibrary.class, Object[].class), null, null);
        init.start();
        init.aload(0);
        init.aload(1);
        init.aload(2);
        init.invokespecial(CodegenUtils.p(AbstractAsmLibraryInterface.class), "<init>", CodegenUtils.sig(Void.TYPE, Runtime.class, NativeLibrary.class));
        builder.emitFieldInitialization(init, 3);
        init.voidreturn();
        init.visitMaxs(10, 10);
        init.visitEnd();
        cv.visitEnd();
        try {
            byte[] bytes = cw.toByteArray();
            if (debug) {
                ClassVisitor trace = AsmUtil.newTraceClassVisitor(new PrintWriter(System.err));
                new ClassReader(bytes).accept(trace, 0);
            }
            Class implClass = classLoader.defineClass(builder.getClassNamePath().replace("/", "."), bytes);
            Constructor cons = implClass.getDeclaredConstructor(Runtime.class, NativeLibrary.class, Object[].class);
            Object result = cons.newInstance(this.runtime, library, builder.getObjectFieldValues());
            System.err.flush();
            System.out.flush();
            compiler.attach(implClass);
            return result;
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    private void generateFunctionNotFound(ClassVisitor cv, String className, String errorFieldName, String functionName, Class returnType, Class[] parameterTypes) {
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(cv, 17, functionName, CodegenUtils.sig(returnType, parameterTypes), null, null);
        mv.start();
        mv.getstatic(className, errorFieldName, CodegenUtils.ci(String.class));
        mv.invokestatic(AsmRuntime.class, "newUnsatisifiedLinkError", UnsatisfiedLinkError.class, String.class);
        mv.athrow();
        mv.visitMaxs(10, 10);
        mv.visitEnd();
    }
}

