/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.launcher.internal.jnr.ffi.provider.jffi;

import com.proofpoint.launcher.internal.jnr.ffi.NativeType;
import com.proofpoint.launcher.internal.jnr.ffi.Runtime;
import com.proofpoint.launcher.internal.jnr.ffi.annotations.Delegate;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.DefaultSignatureType;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.FromNativeConverter;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.SignatureTypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.ToNativeConverter;
import com.proofpoint.launcher.internal.jnr.ffi.provider.FromNativeType;
import com.proofpoint.launcher.internal.jnr.ffi.provider.ToNativeType;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.SimpleNativeContext;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.Types;
import com.proofpoint.launcher.internal.jnr.ffi.util.Annotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;

final class ClosureUtil {
    private ClosureUtil() {
    }

    static ToNativeType getResultType(Runtime runtime, Method m, SignatureTypeMapper typeMapper) {
        Collection<Annotation> annotations = Annotations.sortedAnnotationCollection(m.getAnnotations());
        SimpleNativeContext context = new SimpleNativeContext(runtime, annotations);
        DefaultSignatureType signatureType = DefaultSignatureType.create(m.getReturnType(), context);
        com.proofpoint.launcher.internal.jnr.ffi.mapper.ToNativeType toNativeType = typeMapper.getToNativeType(signatureType, context);
        ToNativeConverter converter = toNativeType != null ? toNativeType.getToNativeConverter() : null;
        Class<Object> javaClass = converter != null ? converter.nativeType() : m.getReturnType();
        NativeType nativeType = Types.getType(runtime, javaClass, annotations).getNativeType();
        return new ToNativeType(m.getReturnType(), nativeType, annotations, converter, null);
    }

    static FromNativeType getParameterType(Runtime runtime, Method m, int idx, SignatureTypeMapper typeMapper) {
        SimpleNativeContext context;
        Collection<Annotation> annotations = Annotations.sortedAnnotationCollection(m.getParameterAnnotations()[idx]);
        Class<?> declaredJavaClass = m.getParameterTypes()[idx];
        DefaultSignatureType signatureType = DefaultSignatureType.create(declaredJavaClass, context = new SimpleNativeContext(runtime, annotations));
        com.proofpoint.launcher.internal.jnr.ffi.mapper.FromNativeType fromNativeType = typeMapper.getFromNativeType(signatureType, context);
        FromNativeConverter converter = fromNativeType != null ? fromNativeType.getFromNativeConverter() : null;
        Class<Object> javaClass = converter != null ? converter.nativeType() : declaredJavaClass;
        NativeType nativeType = Types.getType(runtime, javaClass, annotations).getNativeType();
        return new FromNativeType(declaredJavaClass, nativeType, annotations, converter, null);
    }

    static Method getDelegateMethod(Class closureClass) {
        Method callMethod = null;
        for (Method m : closureClass.getMethods()) {
            if (!m.isAnnotationPresent(Delegate.class) || !Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers())) continue;
            callMethod = m;
            break;
        }
        if (callMethod == null) {
            throw new NoSuchMethodError("no public non-static delegate method defined in " + closureClass.getName());
        }
        return callMethod;
    }
}

