/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.launcher.internal.jnr.ffi.provider.jffi;

import com.kenai.jffi.Function;
import com.kenai.jffi.HeapInvocationBuffer;
import com.kenai.jffi.ObjectParameterStrategy;
import com.kenai.jffi.ObjectParameterType;
import com.proofpoint.launcher.internal.jnr.ffi.Address;
import com.proofpoint.launcher.internal.jnr.ffi.NativeType;
import com.proofpoint.launcher.internal.jnr.ffi.Pointer;
import com.proofpoint.launcher.internal.jnr.ffi.Runtime;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.DataConverter;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.FromNativeContext;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.FromNativeConverter;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.ToNativeContext;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.ToNativeConverter;
import com.proofpoint.launcher.internal.jnr.ffi.provider.FromNativeType;
import com.proofpoint.launcher.internal.jnr.ffi.provider.InvocationSession;
import com.proofpoint.launcher.internal.jnr.ffi.provider.Invoker;
import com.proofpoint.launcher.internal.jnr.ffi.provider.ParameterType;
import com.proofpoint.launcher.internal.jnr.ffi.provider.ResultType;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.AsmRuntime;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.AsmUtil;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.BufferParameterStrategy;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.MemoryUtil;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NativeLibrary;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NullObjectParameterStrategy;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NumberUtil;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.PrimitiveArrayParameterStrategy;
import java.lang.annotation.Annotation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Collection;

final class DefaultInvokerFactory {
    DefaultInvokerFactory() {
    }

    final Invoker createInvoker(Runtime runtime, NativeLibrary nativeLibrary, Function function, ResultType resultType, ParameterType[] parameterTypes) {
        Marshaller[] marshallers = new Marshaller[parameterTypes.length];
        for (int i = 0; i < marshallers.length; ++i) {
            marshallers[i] = DefaultInvokerFactory.getMarshaller(parameterTypes[i]);
        }
        FunctionInvoker invoker = DefaultInvokerFactory.getFunctionInvoker(resultType);
        if (resultType.getFromNativeConverter() != null) {
            invoker = new ConvertingInvoker(resultType.getFromNativeConverter(), resultType.getFromNativeContext(), invoker);
        }
        return new DefaultInvoker(runtime, nativeLibrary, function, invoker, marshallers);
    }

    private static FunctionInvoker getFunctionInvoker(ResultType resultType) {
        Class returnType = resultType.effectiveJavaType();
        if (Void.class.isAssignableFrom(returnType) || Void.TYPE == returnType) {
            return VoidInvoker.INSTANCE;
        }
        if (Boolean.class.isAssignableFrom(returnType) || Boolean.TYPE == returnType) {
            return BooleanInvoker.INSTANCE;
        }
        if (Number.class.isAssignableFrom(returnType) || returnType.isPrimitive()) {
            return new ConvertingInvoker(DefaultInvokerFactory.getNumberResultConverter(resultType), null, new ConvertingInvoker(DefaultInvokerFactory.getNumberDataConverter(resultType.getNativeType()), null, DefaultInvokerFactory.getNumberFunctionInvoker(resultType.getNativeType())));
        }
        if (Pointer.class.isAssignableFrom(returnType)) {
            return PointerInvoker.INSTANCE;
        }
        throw new IllegalArgumentException("Unknown return type: " + returnType);
    }

    private static FunctionInvoker getNumberFunctionInvoker(NativeType nativeType) {
        switch (nativeType) {
            case SCHAR: 
            case UCHAR: 
            case SSHORT: 
            case USHORT: 
            case SINT: 
            case UINT: 
            case SLONG: 
            case ULONG: 
            case SLONGLONG: 
            case ULONGLONG: 
            case ADDRESS: {
                return NumberUtil.sizeof(nativeType) <= 4 ? IntInvoker.INSTANCE : LongInvoker.INSTANCE;
            }
            case FLOAT: {
                return Float32Invoker.INSTANCE;
            }
            case DOUBLE: {
                return Float64Invoker.INSTANCE;
            }
        }
        throw new UnsupportedOperationException("unsupported numeric type: " + (Object)((Object)nativeType));
    }

    static Marshaller getMarshaller(ParameterType parameterType) {
        Marshaller marshaller = DefaultInvokerFactory.getMarshaller(parameterType.effectiveJavaType(), parameterType.getNativeType(), parameterType.getAnnotations());
        return parameterType.getToNativeConverter() != null ? new ToNativeConverterMarshaller(parameterType.getToNativeConverter(), parameterType.getToNativeContext(), marshaller) : marshaller;
    }

    static Marshaller getMarshaller(Class type, NativeType nativeType, Collection<Annotation> annotations) {
        if (Number.class.isAssignableFrom(type) || type.isPrimitive() && Number.class.isAssignableFrom(NumberUtil.getBoxedClass(type))) {
            switch (nativeType) {
                case SCHAR: {
                    return new Int8Marshaller(Signed8Converter.INSTANCE);
                }
                case UCHAR: {
                    return new Int8Marshaller(Unsigned8Converter.INSTANCE);
                }
                case SSHORT: {
                    return new Int16Marshaller(Signed16Converter.INSTANCE);
                }
                case USHORT: {
                    return new Int16Marshaller(Unsigned16Converter.INSTANCE);
                }
                case SINT: {
                    return new Int32Marshaller(Signed32Converter.INSTANCE);
                }
                case UINT: {
                    return new Int32Marshaller(Unsigned32Converter.INSTANCE);
                }
                case SLONG: 
                case ULONG: 
                case ADDRESS: {
                    return NumberUtil.sizeof(nativeType) == 4 ? new Int32Marshaller(DefaultInvokerFactory.getNumberDataConverter(nativeType)) : Int64Marshaller.INSTANCE;
                }
                case SLONGLONG: 
                case ULONGLONG: {
                    return Int64Marshaller.INSTANCE;
                }
                case FLOAT: {
                    return Float32Marshaller.INSTANCE;
                }
                case DOUBLE: {
                    return Float64Marshaller.INSTANCE;
                }
            }
            throw new IllegalArgumentException("Unsupported parameter type: " + type);
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE == type) {
            return BooleanMarshaller.INSTANCE;
        }
        if (Pointer.class.isAssignableFrom(type)) {
            return new PointerMarshaller(annotations);
        }
        if (ByteBuffer.class.isAssignableFrom(type)) {
            return new BufferMarshaller(ObjectParameterType.ComponentType.BYTE, annotations);
        }
        if (ShortBuffer.class.isAssignableFrom(type)) {
            return new BufferMarshaller(ObjectParameterType.ComponentType.SHORT, annotations);
        }
        if (IntBuffer.class.isAssignableFrom(type)) {
            return new BufferMarshaller(ObjectParameterType.ComponentType.INT, annotations);
        }
        if (LongBuffer.class.isAssignableFrom(type)) {
            return new BufferMarshaller(ObjectParameterType.ComponentType.LONG, annotations);
        }
        if (FloatBuffer.class.isAssignableFrom(type)) {
            return new BufferMarshaller(ObjectParameterType.ComponentType.FLOAT, annotations);
        }
        if (DoubleBuffer.class.isAssignableFrom(type)) {
            return new BufferMarshaller(ObjectParameterType.ComponentType.DOUBLE, annotations);
        }
        if (Buffer.class.isAssignableFrom(type)) {
            return new BufferMarshaller(null, annotations);
        }
        if (type.isArray() && type.getComponentType() == Byte.TYPE) {
            return new PrimitiveArrayMarshaller(PrimitiveArrayParameterStrategy.BYTE, annotations);
        }
        if (type.isArray() && type.getComponentType() == Short.TYPE) {
            return new PrimitiveArrayMarshaller(PrimitiveArrayParameterStrategy.SHORT, annotations);
        }
        if (type.isArray() && type.getComponentType() == Integer.TYPE) {
            return new PrimitiveArrayMarshaller(PrimitiveArrayParameterStrategy.INT, annotations);
        }
        if (type.isArray() && type.getComponentType() == Long.TYPE) {
            return new PrimitiveArrayMarshaller(PrimitiveArrayParameterStrategy.LONG, annotations);
        }
        if (type.isArray() && type.getComponentType() == Float.TYPE) {
            return new PrimitiveArrayMarshaller(PrimitiveArrayParameterStrategy.FLOAT, annotations);
        }
        if (type.isArray() && type.getComponentType() == Double.TYPE) {
            return new PrimitiveArrayMarshaller(PrimitiveArrayParameterStrategy.DOUBLE, annotations);
        }
        if (type.isArray() && type.getComponentType() == Boolean.TYPE) {
            return new PrimitiveArrayMarshaller(PrimitiveArrayParameterStrategy.BOOLEAN, annotations);
        }
        throw new IllegalArgumentException("Unsupported parameter type: " + type);
    }

    private static boolean isUnsigned(NativeType nativeType) {
        switch (nativeType) {
            case UCHAR: 
            case USHORT: 
            case UINT: 
            case ULONG: {
                return true;
            }
        }
        return false;
    }

    static DataConverter<Number, Number> getNumberDataConverter(NativeType nativeType) {
        switch (nativeType) {
            case SCHAR: {
                return Signed8Converter.INSTANCE;
            }
            case UCHAR: {
                return Unsigned8Converter.INSTANCE;
            }
            case SSHORT: {
                return Signed16Converter.INSTANCE;
            }
            case USHORT: {
                return Unsigned16Converter.INSTANCE;
            }
            case SINT: {
                return Signed32Converter.INSTANCE;
            }
            case UINT: {
                return Unsigned32Converter.INSTANCE;
            }
            case SLONG: {
                return NumberUtil.sizeof(nativeType) == 4 ? Signed32Converter.INSTANCE : LongLongConverter.INSTANCE;
            }
            case ULONG: 
            case ADDRESS: {
                return NumberUtil.sizeof(nativeType) == 4 ? Unsigned32Converter.INSTANCE : LongLongConverter.INSTANCE;
            }
            case SLONGLONG: 
            case ULONGLONG: {
                return LongLongConverter.INSTANCE;
            }
            case FLOAT: {
                return FloatConverter.INSTANCE;
            }
            case DOUBLE: {
                return DoubleConverter.INSTANCE;
            }
        }
        throw new UnsupportedOperationException("cannot convert " + (Object)((Object)nativeType));
    }

    static ResultConverter<? extends Number, Number> getNumberResultConverter(FromNativeType fromNativeType) {
        if (Byte.class == fromNativeType.effectiveJavaType() || Byte.TYPE == fromNativeType.effectiveJavaType()) {
            return ByteResultConverter.INSTANCE;
        }
        if (Short.class == fromNativeType.effectiveJavaType() || Short.TYPE == fromNativeType.effectiveJavaType()) {
            return ShortResultConverter.INSTANCE;
        }
        if (Integer.class == fromNativeType.effectiveJavaType() || Integer.TYPE == fromNativeType.effectiveJavaType()) {
            return IntegerResultConverter.INSTANCE;
        }
        if (Long.class == fromNativeType.effectiveJavaType() || Long.TYPE == fromNativeType.effectiveJavaType()) {
            return LongResultConverter.INSTANCE;
        }
        if (Float.class == fromNativeType.effectiveJavaType() || Float.TYPE == fromNativeType.effectiveJavaType()) {
            return FloatResultConverter.INSTANCE;
        }
        if (Double.class == fromNativeType.effectiveJavaType() || Double.TYPE == fromNativeType.effectiveJavaType()) {
            return DoubleResultConverter.INSTANCE;
        }
        if (Address.class == fromNativeType.effectiveJavaType()) {
            return AddressResultConverter.INSTANCE;
        }
        throw new UnsupportedOperationException("cannot convert to " + fromNativeType.effectiveJavaType());
    }

    static final class AddressResultConverter
    extends AbstractNumberResultConverter<Address> {
        static final ResultConverter<? extends Number, Number> INSTANCE = new AddressResultConverter();

        AddressResultConverter() {
        }

        @Override
        public Address fromNative(Number value, FromNativeContext fromNativeContext) {
            return Address.valueOf(value.longValue());
        }
    }

    static final class DoubleResultConverter
    extends AbstractNumberResultConverter<Double> {
        static final ResultConverter<? extends Number, Number> INSTANCE = new DoubleResultConverter();

        DoubleResultConverter() {
        }

        @Override
        public Double fromNative(Number value, FromNativeContext fromNativeContext) {
            return value.doubleValue();
        }
    }

    static final class FloatResultConverter
    extends AbstractNumberResultConverter<Float> {
        static final ResultConverter<? extends Number, Number> INSTANCE = new FloatResultConverter();

        FloatResultConverter() {
        }

        @Override
        public Float fromNative(Number value, FromNativeContext fromNativeContext) {
            return Float.valueOf(value.floatValue());
        }
    }

    static final class LongResultConverter
    extends AbstractNumberResultConverter<Long> {
        static final ResultConverter<? extends Number, Number> INSTANCE = new LongResultConverter();

        LongResultConverter() {
        }

        @Override
        public Long fromNative(Number value, FromNativeContext fromNativeContext) {
            return value.longValue();
        }
    }

    static final class IntegerResultConverter
    extends AbstractNumberResultConverter<Integer> {
        static final ResultConverter<? extends Number, Number> INSTANCE = new IntegerResultConverter();

        IntegerResultConverter() {
        }

        @Override
        public Integer fromNative(Number value, FromNativeContext fromNativeContext) {
            return value.intValue();
        }
    }

    static final class ShortResultConverter
    extends AbstractNumberResultConverter<Short> {
        static final ResultConverter<? extends Number, Number> INSTANCE = new ShortResultConverter();

        ShortResultConverter() {
        }

        @Override
        public Short fromNative(Number value, FromNativeContext fromNativeContext) {
            return value.shortValue();
        }
    }

    static final class ByteResultConverter
    extends AbstractNumberResultConverter<Byte> {
        static final ResultConverter<? extends Number, Number> INSTANCE = new ByteResultConverter();

        ByteResultConverter() {
        }

        @Override
        public Byte fromNative(Number value, FromNativeContext fromNativeContext) {
            return value.byteValue();
        }
    }

    static abstract class AbstractNumberResultConverter<T>
    implements ResultConverter<T, Number> {
        AbstractNumberResultConverter() {
        }

        @Override
        public final Class<Number> nativeType() {
            return Number.class;
        }
    }

    static interface ResultConverter<J, N>
    extends FromNativeConverter<J, N> {
        @Override
        public J fromNative(N var1, FromNativeContext var2);
    }

    static final class BooleanConverter
    implements DataConverter<Boolean, Number> {
        static final DataConverter<Boolean, Number> INSTANCE = new BooleanConverter();

        BooleanConverter() {
        }

        @Override
        public Boolean fromNative(Number nativeValue, FromNativeContext context) {
            return (nativeValue.intValue() & 1) != 0;
        }

        @Override
        public Number toNative(Boolean value, ToNativeContext context) {
            return value != false ? 1 : 0;
        }

        @Override
        public Class<Number> nativeType() {
            return Number.class;
        }
    }

    static final class DoubleConverter
    extends NumberDataConverter {
        static final NumberDataConverter INSTANCE = new DoubleConverter();

        DoubleConverter() {
        }

        @Override
        public Number fromNative(Number nativeValue, FromNativeContext context) {
            return nativeValue.doubleValue();
        }

        @Override
        public Number toNative(Number value, ToNativeContext context) {
            return value.doubleValue();
        }
    }

    static final class FloatConverter
    extends NumberDataConverter {
        static final NumberDataConverter INSTANCE = new FloatConverter();

        FloatConverter() {
        }

        @Override
        public Number fromNative(Number nativeValue, FromNativeContext context) {
            return Float.valueOf(nativeValue.floatValue());
        }

        @Override
        public Number toNative(Number value, ToNativeContext context) {
            return Float.valueOf(value.floatValue());
        }
    }

    static final class LongLongConverter
    extends NumberDataConverter {
        static final NumberDataConverter INSTANCE = new LongLongConverter();

        LongLongConverter() {
        }

        @Override
        public Number fromNative(Number nativeValue, FromNativeContext context) {
            return nativeValue.longValue();
        }

        @Override
        public Number toNative(Number value, ToNativeContext context) {
            return value.longValue();
        }
    }

    static final class Unsigned32Converter
    extends NumberDataConverter {
        static final NumberDataConverter INSTANCE = new Unsigned32Converter();

        Unsigned32Converter() {
        }

        @Override
        public Number fromNative(Number nativeValue, FromNativeContext context) {
            long value = nativeValue.intValue();
            return value < 0L ? (value & Integer.MAX_VALUE) + 0x80000000L : value;
        }

        @Override
        public Number toNative(Number value, ToNativeContext context) {
            return value.longValue() & 0xFFFFFFFFL;
        }
    }

    static final class Signed32Converter
    extends NumberDataConverter {
        static final NumberDataConverter INSTANCE = new Signed32Converter();

        Signed32Converter() {
        }

        @Override
        public Number fromNative(Number nativeValue, FromNativeContext context) {
            return nativeValue.intValue();
        }

        @Override
        public Number toNative(Number value, ToNativeContext context) {
            return value.intValue();
        }
    }

    static final class Unsigned16Converter
    extends NumberDataConverter {
        static final NumberDataConverter INSTANCE = new Unsigned16Converter();

        Unsigned16Converter() {
        }

        @Override
        public Number fromNative(Number nativeValue, FromNativeContext context) {
            int value = nativeValue.shortValue();
            return value < 0 ? (value & Short.MAX_VALUE) + 32768 : value;
        }

        @Override
        public Number toNative(Number value, ToNativeContext context) {
            return value.intValue() & 0xFFFF;
        }
    }

    static final class Signed16Converter
    extends NumberDataConverter {
        static final NumberDataConverter INSTANCE = new Signed16Converter();

        Signed16Converter() {
        }

        @Override
        public Number fromNative(Number nativeValue, FromNativeContext context) {
            return nativeValue.shortValue();
        }

        @Override
        public Number toNative(Number value, ToNativeContext context) {
            return value.shortValue();
        }
    }

    static final class Unsigned8Converter
    extends NumberDataConverter {
        static final NumberDataConverter INSTANCE = new Unsigned8Converter();

        Unsigned8Converter() {
        }

        @Override
        public Number fromNative(Number nativeValue, FromNativeContext context) {
            int value = nativeValue.byteValue();
            return value < 0 ? (value & 0x7F) + 128 : value;
        }

        @Override
        public Number toNative(Number value, ToNativeContext context) {
            return value.intValue() & 0xFFFF;
        }
    }

    static final class Signed8Converter
    extends NumberDataConverter {
        static final NumberDataConverter INSTANCE = new Signed8Converter();

        Signed8Converter() {
        }

        @Override
        public Number fromNative(Number nativeValue, FromNativeContext context) {
            return nativeValue.byteValue();
        }

        @Override
        public Number toNative(Number value, ToNativeContext context) {
            return value.byteValue();
        }
    }

    static abstract class NumberDataConverter
    implements DataConverter<Number, Number> {
        NumberDataConverter() {
        }

        @Override
        public final Class<Number> nativeType() {
            return Number.class;
        }
    }

    static class ToNativeConverterMarshaller
    implements Marshaller {
        private final ToNativeConverter converter;
        private final ToNativeContext context;
        private final Marshaller marshaller;
        private final boolean isPostInvokeRequired;

        public ToNativeConverterMarshaller(ToNativeConverter toNativeConverter, ToNativeContext toNativeContext, Marshaller marshaller) {
            this.converter = toNativeConverter;
            this.context = toNativeContext;
            this.marshaller = marshaller;
            this.isPostInvokeRequired = this.converter instanceof ToNativeConverter.PostInvocation;
        }

        @Override
        public void marshal(InvocationSession session, HeapInvocationBuffer buffer, final Object parameter) {
            final Object nativeValue = this.converter.toNative(parameter, this.context);
            this.marshaller.marshal(session, buffer, nativeValue);
            if (this.isPostInvokeRequired) {
                session.addPostInvoke(new InvocationSession.PostInvoke(){

                    @Override
                    public void postInvoke() {
                        ((ToNativeConverter.PostInvocation)ToNativeConverterMarshaller.this.converter).postInvoke(parameter, nativeValue, ToNativeConverterMarshaller.this.context);
                    }
                });
            } else {
                session.keepAlive(nativeValue);
            }
        }
    }

    static class BufferMarshaller
    implements Marshaller {
        private final ObjectParameterType.ComponentType componentType;
        private final int flags;

        BufferMarshaller(ObjectParameterType.ComponentType componentType, Collection<Annotation> annotations) {
            this.componentType = componentType;
            this.flags = AsmUtil.getNativeArrayFlags(annotations);
        }

        @Override
        public final void marshal(InvocationSession session, HeapInvocationBuffer buffer, Object parameter) {
            BufferParameterStrategy strategy = this.componentType != null ? AsmRuntime.bufferParameterStrategy((Buffer)parameter, this.componentType) : AsmRuntime.pointerParameterStrategy((Buffer)parameter);
            buffer.putObject(parameter, (ObjectParameterStrategy)strategy, this.flags);
        }
    }

    static class PrimitiveArrayMarshaller
    implements Marshaller {
        private final PrimitiveArrayParameterStrategy strategy;
        private final int flags;

        protected PrimitiveArrayMarshaller(PrimitiveArrayParameterStrategy strategy, Collection<Annotation> annotations) {
            this.strategy = strategy;
            this.flags = AsmUtil.getNativeArrayFlags(annotations);
        }

        @Override
        public final void marshal(InvocationSession session, HeapInvocationBuffer buffer, Object parameter) {
            buffer.putObject(parameter, (ObjectParameterStrategy)(parameter != null ? this.strategy : NullObjectParameterStrategy.NULL), this.flags);
        }
    }

    static class PointerMarshaller
    implements Marshaller {
        private final int flags;

        PointerMarshaller(Collection<Annotation> annotations) {
            this.flags = AsmUtil.getNativeArrayFlags(annotations);
        }

        @Override
        public void marshal(InvocationSession session, HeapInvocationBuffer buffer, Object parameter) {
            buffer.putObject(parameter, (ObjectParameterStrategy)AsmRuntime.pointerParameterStrategy((Pointer)parameter), this.flags);
        }
    }

    static class Float64Marshaller
    implements Marshaller {
        static final Marshaller INSTANCE = new Float64Marshaller();

        Float64Marshaller() {
        }

        @Override
        public void marshal(InvocationSession session, HeapInvocationBuffer buffer, Object parameter) {
            buffer.putDouble(((Number)parameter).doubleValue());
        }
    }

    static class Float32Marshaller
    implements Marshaller {
        static final Marshaller INSTANCE = new Float32Marshaller();

        Float32Marshaller() {
        }

        @Override
        public void marshal(InvocationSession session, HeapInvocationBuffer buffer, Object parameter) {
            buffer.putFloat(((Number)parameter).floatValue());
        }
    }

    static class Int64Marshaller
    implements Marshaller {
        static final Marshaller INSTANCE = new Int64Marshaller();

        Int64Marshaller() {
        }

        @Override
        public void marshal(InvocationSession session, HeapInvocationBuffer buffer, Object parameter) {
            buffer.putLong(((Number)parameter).longValue());
        }
    }

    static class Int32Marshaller
    implements Marshaller {
        private final ToNativeConverter<Number, Number> toNativeConverter;

        Int32Marshaller(ToNativeConverter<Number, Number> toNativeConverter) {
            this.toNativeConverter = toNativeConverter;
        }

        @Override
        public void marshal(InvocationSession session, HeapInvocationBuffer buffer, Object parameter) {
            buffer.putInt(this.toNativeConverter.toNative((Number)parameter, null).intValue());
        }
    }

    static class Int16Marshaller
    implements Marshaller {
        private final ToNativeConverter<Number, Number> toNativeConverter;

        Int16Marshaller(ToNativeConverter<Number, Number> toNativeConverter) {
            this.toNativeConverter = toNativeConverter;
        }

        @Override
        public void marshal(InvocationSession session, HeapInvocationBuffer buffer, Object parameter) {
            buffer.putShort(this.toNativeConverter.toNative((Number)parameter, null).intValue());
        }
    }

    static class Int8Marshaller
    implements Marshaller {
        private final ToNativeConverter<Number, Number> toNativeConverter;

        Int8Marshaller(ToNativeConverter<Number, Number> toNativeConverter) {
            this.toNativeConverter = toNativeConverter;
        }

        @Override
        public void marshal(InvocationSession session, HeapInvocationBuffer buffer, Object parameter) {
            buffer.putByte(this.toNativeConverter.toNative((Number)parameter, null).intValue());
        }
    }

    static class BooleanMarshaller
    implements Marshaller {
        static final Marshaller INSTANCE = new BooleanMarshaller();

        BooleanMarshaller() {
        }

        @Override
        public void marshal(InvocationSession session, HeapInvocationBuffer buffer, Object parameter) {
            buffer.putInt((Boolean)parameter != false ? 1 : 0);
        }
    }

    static class PointerInvoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new PointerInvoker();

        PointerInvoker() {
        }

        @Override
        public final Object invoke(Runtime runtime, Function function, HeapInvocationBuffer buffer) {
            return MemoryUtil.newPointer(runtime, invoker.invokeAddress(function, buffer));
        }
    }

    static class Float64Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Float64Invoker();

        Float64Invoker() {
        }

        @Override
        public final Object invoke(Runtime runtime, Function function, HeapInvocationBuffer buffer) {
            return invoker.invokeDouble(function, buffer);
        }
    }

    static class Float32Invoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new Float32Invoker();

        Float32Invoker() {
        }

        @Override
        public final Object invoke(Runtime runtime, Function function, HeapInvocationBuffer buffer) {
            return Float.valueOf(invoker.invokeFloat(function, buffer));
        }
    }

    static class LongInvoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new LongInvoker();

        LongInvoker() {
        }

        @Override
        public final Object invoke(Runtime runtime, Function function, HeapInvocationBuffer buffer) {
            return invoker.invokeLong(function, buffer);
        }
    }

    static class IntInvoker
    extends BaseInvoker {
        static final FunctionInvoker INSTANCE = new IntInvoker();

        IntInvoker() {
        }

        @Override
        public final Object invoke(Runtime runtime, Function function, HeapInvocationBuffer buffer) {
            return invoker.invokeInt(function, buffer);
        }
    }

    static class BooleanInvoker
    extends BaseInvoker {
        static FunctionInvoker INSTANCE = new BooleanInvoker();

        BooleanInvoker() {
        }

        @Override
        public final Object invoke(Runtime runtime, Function function, HeapInvocationBuffer buffer) {
            return invoker.invokeInt(function, buffer) != 0;
        }
    }

    static class VoidInvoker
    extends BaseInvoker {
        static FunctionInvoker INSTANCE = new VoidInvoker();

        VoidInvoker() {
        }

        @Override
        public final Object invoke(Runtime runtime, Function function, HeapInvocationBuffer buffer) {
            invoker.invokeInt(function, buffer);
            return null;
        }
    }

    static class ConvertingInvoker
    extends BaseInvoker {
        private final FromNativeConverter fromNativeConverter;
        private final FromNativeContext fromNativeContext;
        private final FunctionInvoker nativeInvoker;

        public ConvertingInvoker(FromNativeConverter converter, FromNativeContext context, FunctionInvoker nativeInvoker) {
            this.fromNativeConverter = converter;
            this.fromNativeContext = context;
            this.nativeInvoker = nativeInvoker;
        }

        @Override
        public final Object invoke(Runtime runtime, Function function, HeapInvocationBuffer buffer) {
            return this.fromNativeConverter.fromNative(this.nativeInvoker.invoke(runtime, function, buffer), this.fromNativeContext);
        }
    }

    static abstract class BaseInvoker
    implements FunctionInvoker {
        static com.kenai.jffi.Invoker invoker = com.kenai.jffi.Invoker.getInstance();

        BaseInvoker() {
        }
    }

    static interface FunctionInvoker {
        public Object invoke(Runtime var1, Function var2, HeapInvocationBuffer var3);
    }

    static interface Marshaller {
        public void marshal(InvocationSession var1, HeapInvocationBuffer var2, Object var3);
    }

    static class DefaultInvoker
    implements Invoker {
        protected final Runtime runtime;
        final Function function;
        final FunctionInvoker functionInvoker;
        final Marshaller[] marshallers;
        final NativeLibrary nativeLibrary;

        DefaultInvoker(Runtime runtime, NativeLibrary nativeLibrary, Function function, FunctionInvoker invoker, Marshaller[] marshallers) {
            this.runtime = runtime;
            this.nativeLibrary = nativeLibrary;
            this.function = function;
            this.functionInvoker = invoker;
            this.marshallers = marshallers;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Object invoke(Object self, Object[] parameters) {
            InvocationSession session = new InvocationSession();
            HeapInvocationBuffer buffer = new HeapInvocationBuffer(this.function.getCallContext());
            try {
                if (parameters != null) {
                    for (int i = 0; i < parameters.length; ++i) {
                        this.marshallers[i].marshal(session, buffer, parameters[i]);
                    }
                }
                Object object = this.functionInvoker.invoke(this.runtime, this.function, buffer);
                return object;
            }
            finally {
                session.finish();
            }
        }
    }
}

