/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.launcher.internal.jnr.ffi.provider.jffi;

import com.proofpoint.launcher.internal.jnr.ffi.LibraryLoader;
import com.proofpoint.launcher.internal.jnr.ffi.LibraryOption;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.AsmLibraryLoader;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NativeLibrary;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.ReflectionLibraryLoader;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.Util;
import java.util.Collection;
import java.util.Map;

class NativeLibraryLoader<T>
extends LibraryLoader<T> {
    static final boolean ASM_ENABLED = Util.getBooleanProperty("com.proofpoint.launcher.internal.jnr.ffi.asm.enabled", true);

    NativeLibraryLoader(Class<T> interfaceClass) {
        super(interfaceClass);
    }

    @Override
    public T loadLibrary(Class<T> interfaceClass, Collection<String> libraryNames, Collection<String> searchPaths, Map<LibraryOption, Object> options) {
        NativeLibrary nativeLibrary = new NativeLibrary(libraryNames, searchPaths);
        try {
            return ASM_ENABLED ? new AsmLibraryLoader().loadLibrary(nativeLibrary, interfaceClass, options) : new ReflectionLibraryLoader().loadLibrary(nativeLibrary, interfaceClass, options);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

