/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.launcher.internal.jnr.ffi.provider.jffi;

import com.kenai.jffi.Function;
import com.proofpoint.launcher.internal.jnr.ffi.CallingConvention;
import com.proofpoint.launcher.internal.jnr.ffi.LibraryOption;
import com.proofpoint.launcher.internal.jnr.ffi.Runtime;
import com.proofpoint.launcher.internal.jnr.ffi.Variable;
import com.proofpoint.launcher.internal.jnr.ffi.annotations.StdCall;
import com.proofpoint.launcher.internal.jnr.ffi.annotations.Synchronized;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.CachingTypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.CompositeTypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.DefaultSignatureType;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.FromNativeContext;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.FunctionMapper;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.MethodResultContext;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.SignatureTypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.SignatureTypeMapperAdapter;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.TypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.provider.IdentityFunctionMapper;
import com.proofpoint.launcher.internal.jnr.ffi.provider.Invoker;
import com.proofpoint.launcher.internal.jnr.ffi.provider.LoadedLibrary;
import com.proofpoint.launcher.internal.jnr.ffi.provider.NativeInvocationHandler;
import com.proofpoint.launcher.internal.jnr.ffi.provider.NullTypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.provider.ParameterType;
import com.proofpoint.launcher.internal.jnr.ffi.provider.ResultType;
import com.proofpoint.launcher.internal.jnr.ffi.provider.SigType;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.AsmClassLoader;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.DefaultInvokerFactory;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.InvokerTypeMapper;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.InvokerUtil;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.LibraryLoader;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NativeClosureManager;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NativeFunctionMapperContext;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NativeLibrary;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NativeLibraryLoader;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.NativeRuntime;
import com.proofpoint.launcher.internal.jnr.ffi.provider.jffi.ReflectionVariableAccessorGenerator;
import com.proofpoint.launcher.internal.jnr.ffi.util.Annotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

class ReflectionLibraryLoader
extends LibraryLoader {
    ReflectionLibraryLoader() {
    }

    @Override
    <T> T loadLibrary(NativeLibrary library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
        return interfaceClass.cast(Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass, LoadedLibrary.class}, (InvocationHandler)new NativeInvocationHandler(new LazyLoader(library, interfaceClass, libraryOptions))));
    }

    private static final class LazyLoader<T>
    extends AbstractMap<Method, Invoker> {
        private final DefaultInvokerFactory invokerFactory = new DefaultInvokerFactory();
        private final Runtime runtime = NativeRuntime.getInstance();
        private final AsmClassLoader classLoader = new AsmClassLoader();
        private final SignatureTypeMapper typeMapper;
        private final FunctionMapper functionMapper;
        private final CallingConvention libraryCallingConvention;
        private final boolean libraryIsSynchronized;
        private final NativeLibrary library;
        private final Class<T> interfaceClass;
        private final Map<LibraryOption, ?> libraryOptions;

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private LazyLoader(NativeLibrary library, Class<T> interfaceClass, Map<LibraryOption, ?> libraryOptions) {
            void var4_9;
            this.library = library;
            this.interfaceClass = interfaceClass;
            this.libraryOptions = libraryOptions;
            FunctionMapper functionMapper = this.functionMapper = libraryOptions.containsKey((Object)LibraryOption.FunctionMapper) ? (FunctionMapper)libraryOptions.get((Object)LibraryOption.FunctionMapper) : IdentityFunctionMapper.getInstance();
            if (libraryOptions.containsKey((Object)LibraryOption.TypeMapper)) {
                Object tm = libraryOptions.get((Object)LibraryOption.TypeMapper);
                if (tm instanceof SignatureTypeMapper) {
                    SignatureTypeMapper signatureTypeMapper = (SignatureTypeMapper)tm;
                } else {
                    if (!(tm instanceof TypeMapper)) throw new IllegalArgumentException("TypeMapper option is not a valid TypeMapper instance");
                    SignatureTypeMapperAdapter signatureTypeMapperAdapter = new SignatureTypeMapperAdapter((TypeMapper)tm);
                }
            } else {
                NullTypeMapper nullTypeMapper = new NullTypeMapper();
            }
            this.typeMapper = new CompositeTypeMapper(new SignatureTypeMapper[]{var4_9, new CachingTypeMapper(new InvokerTypeMapper(new NativeClosureManager(this.runtime, (SignatureTypeMapper)var4_9, this.classLoader), this.classLoader, NativeLibraryLoader.ASM_ENABLED))});
            this.libraryCallingConvention = InvokerUtil.getCallingConvention(interfaceClass, libraryOptions);
            this.libraryIsSynchronized = interfaceClass.isAnnotationPresent(Synchronized.class);
        }

        @Override
        public Set<Map.Entry<Method, Invoker>> entrySet() {
            throw new UnsupportedOperationException("not implemented");
        }

        @Override
        public synchronized Invoker get(Object key) {
            if (!(key instanceof Method)) {
                throw new IllegalArgumentException("key not instance of Method");
            }
            Method method = (Method)key;
            if (Variable.class.isAssignableFrom(method.getReturnType())) {
                return this.getVariableAccessor(method);
            }
            if (method.getName().equals("getRuntime") && method.getReturnType().isAssignableFrom(NativeRuntime.class)) {
                return new GetRuntimeInvoker(this.runtime);
            }
            return this.getFunctionInvoker(method);
        }

        private Invoker getFunctionInvoker(Method method) {
            Collection<Annotation> annotations = Annotations.sortedAnnotationCollection(method.getAnnotations());
            String functionName = this.functionMapper.mapFunctionName(method.getName(), new NativeFunctionMapperContext(this.library, annotations));
            long functionAddress = this.library.getSymbolAddress(functionName);
            if (functionAddress == 0L) {
                return new FunctionNotFoundInvoker(method, functionName);
            }
            MethodResultContext resultContext = new MethodResultContext(NativeRuntime.getInstance(), method);
            DefaultSignatureType signatureType = DefaultSignatureType.create(method.getReturnType(), resultContext);
            ResultType resultType = InvokerUtil.getResultType(this.runtime, method.getReturnType(), resultContext.getAnnotations(), this.typeMapper.getFromNativeType(signatureType, resultContext), (FromNativeContext)resultContext);
            SigType[] parameterTypes = InvokerUtil.getParameterTypes(this.runtime, this.typeMapper, method);
            CallingConvention callingConvention = method.isAnnotationPresent(StdCall.class) ? CallingConvention.STDCALL : this.libraryCallingConvention;
            Function function = new Function(functionAddress, InvokerUtil.getCallContext(resultType, parameterTypes, callingConvention, InvokerUtil.requiresErrno(method)));
            Invoker invoker = this.invokerFactory.createInvoker(this.runtime, this.library, function, resultType, (ParameterType[])parameterTypes);
            return this.libraryIsSynchronized || method.isAnnotationPresent(Synchronized.class) ? new SynchronizedInvoker(invoker) : invoker;
        }

        private Invoker getVariableAccessor(Method method) {
            Collection<Annotation> annotations = Annotations.sortedAnnotationCollection(method.getAnnotations());
            String functionName = this.functionMapper.mapFunctionName(method.getName(), new NativeFunctionMapperContext(this.library, annotations));
            long symbolAddress = this.library.getSymbolAddress(functionName);
            if (symbolAddress == 0L) {
                return new FunctionNotFoundInvoker(method, functionName);
            }
            Variable variable = ReflectionVariableAccessorGenerator.createVariableAccessor(this.runtime, method, symbolAddress, this.typeMapper, annotations);
            return new VariableAcccessorInvoker(variable);
        }

        private static final class VariableAcccessorInvoker
        implements Invoker {
            private final Variable variable;

            private VariableAcccessorInvoker(Variable variable) {
                this.variable = variable;
            }

            @Override
            public Object invoke(Object self, Object[] parameters) {
                return this.variable;
            }
        }
    }

    private static final class GetRuntimeInvoker
    implements Invoker {
        private final Runtime runtime;

        private GetRuntimeInvoker(Runtime runtime) {
            this.runtime = runtime;
        }

        @Override
        public Object invoke(Object self, Object[] parameters) {
            return this.runtime;
        }
    }

    private static final class FunctionNotFoundInvoker
    implements Invoker {
        private final Method method;
        private final String functionName;

        private FunctionNotFoundInvoker(Method method, String functionName) {
            this.method = method;
            this.functionName = functionName;
        }

        @Override
        public Object invoke(Object self, Object[] parameters) {
            throw new UnsatisfiedLinkError(String.format("native method '%s' not found for method %s", this.functionName, this.method));
        }
    }

    private static final class SynchronizedInvoker
    implements Invoker {
        private final Invoker invoker;

        public SynchronizedInvoker(Invoker invoker) {
            this.invoker = invoker;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object self, Object[] parameters) {
            Object object = self;
            synchronized (object) {
                return this.invoker.invoke(self, parameters);
            }
        }
    }
}

