/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.launcher.internal.jnr.posix;

import com.proofpoint.launcher.internal.jnr.constants.platform.Sysconf;
import com.proofpoint.launcher.internal.jnr.ffi.LibraryLoader;
import com.proofpoint.launcher.internal.jnr.ffi.Pointer;
import com.proofpoint.launcher.internal.jnr.ffi.mapper.FromNativeContext;
import com.proofpoint.launcher.internal.jnr.posix.BaseNativePOSIX;
import com.proofpoint.launcher.internal.jnr.posix.FileStat;
import com.proofpoint.launcher.internal.jnr.posix.LibCProvider;
import com.proofpoint.launcher.internal.jnr.posix.MacOSFileStat;
import com.proofpoint.launcher.internal.jnr.posix.MacOSMsgHdr;
import com.proofpoint.launcher.internal.jnr.posix.MacOSPasswd;
import com.proofpoint.launcher.internal.jnr.posix.MacOSSocketMacros;
import com.proofpoint.launcher.internal.jnr.posix.MsgHdr;
import com.proofpoint.launcher.internal.jnr.posix.NSGetEnviron;
import com.proofpoint.launcher.internal.jnr.posix.NativeTimes;
import com.proofpoint.launcher.internal.jnr.posix.POSIXHandler;
import com.proofpoint.launcher.internal.jnr.posix.SocketMacros;
import com.proofpoint.launcher.internal.jnr.posix.Times;

final class MacOSPOSIX
extends BaseNativePOSIX {
    private final NSGetEnviron environ;
    public static final BaseNativePOSIX.PointerConverter PASSWD = new BaseNativePOSIX.PointerConverter(){

        public Object fromNative(Object arg, FromNativeContext ctx) {
            return arg != null ? new MacOSPasswd((Pointer)arg) : null;
        }
    };

    MacOSPOSIX(LibCProvider libcProvider, POSIXHandler handler) {
        super(libcProvider, handler);
        LibraryLoader<NSGetEnviron> loader = LibraryLoader.create(NSGetEnviron.class);
        loader.library("libSystem.B.dylib");
        this.environ = loader.load();
    }

    @Override
    public FileStat allocateStat() {
        return new MacOSFileStat(this);
    }

    @Override
    public MsgHdr allocateMsgHdr() {
        return new MacOSMsgHdr(this);
    }

    @Override
    public SocketMacros socketMacros() {
        return MacOSSocketMacros.INSTANCE;
    }

    @Override
    public long sysconf(Sysconf name) {
        return this.libc().sysconf(name);
    }

    @Override
    public Times times() {
        return NativeTimes.times(this);
    }

    @Override
    public Pointer environ() {
        return this.environ._NSGetEnviron().getPointer(0L);
    }
}

