/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.launcher.internal.jnr.posix;

import com.proofpoint.launcher.internal.jnr.ffi.Pointer;
import com.proofpoint.launcher.internal.jnr.ffi.Runtime;
import com.proofpoint.launcher.internal.jnr.ffi.StructLayout;
import com.proofpoint.launcher.internal.jnr.posix.NativePasswd;
import com.proofpoint.launcher.internal.jnr.posix.Passwd;

public class OpenBSDPasswd
extends NativePasswd
implements Passwd {
    private static final Layout layout = new Layout(Runtime.getSystemRuntime());

    OpenBSDPasswd(Pointer memory) {
        super(memory);
    }

    @Override
    public String getAccessClass() {
        return OpenBSDPasswd.layout.pw_class.get(this.memory);
    }

    @Override
    public String getGECOS() {
        return OpenBSDPasswd.layout.pw_gecos.get(this.memory);
    }

    @Override
    public long getGID() {
        return OpenBSDPasswd.layout.pw_gid.get(this.memory);
    }

    @Override
    public String getHome() {
        return OpenBSDPasswd.layout.pw_dir.get(this.memory);
    }

    @Override
    public String getLoginName() {
        return OpenBSDPasswd.layout.pw_name.get(this.memory);
    }

    @Override
    public int getPasswdChangeTime() {
        return OpenBSDPasswd.layout.pw_change.intValue(this.memory);
    }

    @Override
    public String getPassword() {
        return OpenBSDPasswd.layout.pw_passwd.get(this.memory);
    }

    @Override
    public String getShell() {
        return OpenBSDPasswd.layout.pw_shell.get(this.memory);
    }

    @Override
    public long getUID() {
        return OpenBSDPasswd.layout.pw_uid.get(this.memory);
    }

    @Override
    public int getExpire() {
        return OpenBSDPasswd.layout.pw_expire.intValue(this.memory);
    }

    private static final class Layout
    extends StructLayout {
        public final StructLayout.UTF8StringRef pw_name = new StructLayout.UTF8StringRef(this);
        public final StructLayout.UTF8StringRef pw_passwd = new StructLayout.UTF8StringRef(this);
        public final StructLayout.Unsigned32 pw_uid = new StructLayout.Unsigned32(this);
        public final StructLayout.Unsigned32 pw_gid = new StructLayout.Unsigned32(this);
        public final StructLayout.Signed64 pw_change = new StructLayout.Signed64(this);
        public final StructLayout.UTF8StringRef pw_class = new StructLayout.UTF8StringRef(this);
        public final StructLayout.UTF8StringRef pw_gecos = new StructLayout.UTF8StringRef(this);
        public final StructLayout.UTF8StringRef pw_dir = new StructLayout.UTF8StringRef(this);
        public final StructLayout.UTF8StringRef pw_shell = new StructLayout.UTF8StringRef(this);
        public final StructLayout.Signed64 pw_expire = new StructLayout.Signed64(this);

        private Layout(Runtime runtime) {
            super(runtime);
        }
    }
}

