/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jmx;

import com.proofpoint.http.server.HttpServerConfig;
import com.proofpoint.jmx.AdminServerConfig;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public class AdminServerCredentialVerifier {
    private static final Base64.Decoder decoder = Base64.getDecoder();
    private final String username;
    private final String password;
    private final boolean httpsEnabled;

    @Inject
    public AdminServerCredentialVerifier(AdminServerConfig adminServerConfig, HttpServerConfig httpServerConfig) {
        this.username = Objects.requireNonNull(adminServerConfig, "adminServerConfig is null").getUsername();
        this.password = adminServerConfig.getPassword();
        this.httpsEnabled = Objects.requireNonNull(httpServerConfig, "httpServerConfig is null").isHttpsEnabled();
    }

    public void authenticate(SecurityContext securityContext, String authHeader) {
        String credentials;
        int index;
        if (!this.httpsEnabled) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).header("Content-Type", (Object)"text/plain").entity((Object)"HTTPS not enabled").build());
        }
        if (securityContext.isUserInRole("server.admin") && !"none".equals(securityContext.getAuthenticationScheme())) {
            return;
        }
        if (this.username == null || this.password == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).header("Content-Type", (Object)"text/plain").entity((Object)"Administrator password not configured").build());
        }
        if (authHeader == null || !authHeader.startsWith("Basic ")) {
            AdminServerCredentialVerifier.unauthorized();
        }
        if ((index = (credentials = new String(decoder.decode(authHeader.substring("Basic ".length())), StandardCharsets.UTF_8)).indexOf(58)) < 0 || !this.username.equals(credentials.substring(0, index)) || !this.password.equals(credentials.substring(index + 1))) {
            AdminServerCredentialVerifier.unauthorized();
        }
    }

    private static void unauthorized() {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"Administration port\"").header("Content-Type", (Object)"text/plain").entity((Object)"Incorrect username or password").build());
    }
}

