/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jmx;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.proofpoint.configuration.ConfigurationFactory;
import com.proofpoint.configuration.ConfigurationInspector;
import com.proofpoint.jaxrs.AccessDoesNotRequireAuthentication;
import com.proofpoint.jmx.AutoValue_ConfigurationResource_ConfigurationEntry;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/admin/configuration")
@AccessDoesNotRequireAuthentication
public class ConfigurationResource {
    private final ConfigurationFactory configurationFactory;

    @Inject
    public ConfigurationResource(ConfigurationFactory configurationFactory) {
        this.configurationFactory = Objects.requireNonNull(configurationFactory, "configurationFactory is null");
    }

    @GET
    @Produces(value={"application/json"})
    public Map<String, ConfigurationEntry> getConfiguration() {
        ConfigurationInspector configurationInspector = new ConfigurationInspector();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ConfigurationInspector.ConfigRecord record : configurationInspector.inspect(this.configurationFactory)) {
            for (ConfigurationInspector.ConfigAttribute attribute : record.getAttributes()) {
                builder.put((Object)attribute.getPropertyName(), (Object)new AutoValue_ConfigurationResource_ConfigurationEntry(attribute));
            }
        }
        return builder.build();
    }

    @AutoValue
    public static abstract class ConfigurationEntry {
        abstract ConfigurationInspector.ConfigAttribute getConfigAttribute();

        @JsonProperty
        String getDefaultValue() {
            return this.getConfigAttribute().getDefaultValue();
        }

        @JsonProperty
        String getCurrentValue() {
            return this.getConfigAttribute().getCurrentValue();
        }

        @JsonProperty
        String getDescription() {
            String description = this.getConfigAttribute().getDescription();
            if (description.isEmpty()) {
                return null;
            }
            return description;
        }
    }
}

