/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jmx;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.proofpoint.configuration.ConfigBinder;
import com.proofpoint.discovery.client.DiscoveryBinder;
import com.proofpoint.discovery.client.announce.ServiceAnnouncement;
import com.proofpoint.http.server.HttpServerInfo;
import com.proofpoint.jaxrs.JaxrsBinder;
import com.proofpoint.jmx.AdminServerConfig;
import com.proofpoint.jmx.AdminServerCredentialVerifier;
import com.proofpoint.jmx.ConfigurationResource;
import com.proofpoint.jmx.MBeanResource;
import com.proofpoint.jmx.StopAnnouncingResource;
import com.proofpoint.jmx.VersionResource;
import com.proofpoint.json.JsonBinder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;

public class JmxHttpModule
implements Module {
    public void configure(Binder binder) {
        binder.disableCircularProxies();
        JaxrsBinder.jaxrsBinder((Binder)binder).bindAdmin(MBeanResource.class);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(InetAddress.class).toInstance((Object)ToStringSerializer.instance);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(ObjectName.class).toInstance((Object)ToStringSerializer.instance);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(OpenType.class).toInstance((Object)ToStringSerializer.instance);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(CompositeData.class).to(CompositeDataSerializer.class);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(TabularData.class).to(TabularDataSerializer.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bindAdmin(ConfigurationResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bindAdmin(VersionResource.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bindAdmin(StopAnnouncingResource.class);
        ConfigBinder.bindConfig((Binder)binder).bind(AdminServerConfig.class);
        binder.bind(AdminServerCredentialVerifier.class).in(Scopes.SINGLETON);
        ServiceAnnouncement.ServiceAnnouncementBuilder serviceAnnouncementBuilder = ServiceAnnouncement.serviceAnnouncement((String)"jmx-http");
        DiscoveryBinder.discoveryBinder((Binder)binder).bindServiceAnnouncement((Provider)new JmxHttpAnnouncementProvider(serviceAnnouncementBuilder));
    }

    private static Map<String, Object> toMap(CompositeData data) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Set<String> keySet = data.getCompositeType().keySet();
        if (keySet != null) {
            for (String key : keySet) {
                Object value;
                if (key == null || (value = data.get(key)) == null) continue;
                builder.put((Object)key, value);
            }
        }
        return builder.build();
    }

    private static List<Map<String, Object>> toList(TabularData data) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Set<?> keySet = data.keySet();
        if (keySet != null) {
            for (List key : keySet) {
                Object[] index;
                CompositeData value;
                if (key == null || key.isEmpty() || (value = data.get(index = key.toArray(new Object[0]))) == null) continue;
                builder.add(JmxHttpModule.toMap(value));
            }
        }
        return builder.build();
    }

    static class JmxHttpAnnouncementProvider
    implements Provider<ServiceAnnouncement> {
        private final ServiceAnnouncement.ServiceAnnouncementBuilder builder;
        private HttpServerInfo httpServerInfo;

        JmxHttpAnnouncementProvider(ServiceAnnouncement.ServiceAnnouncementBuilder serviceAnnouncementBuilder) {
            this.builder = serviceAnnouncementBuilder;
        }

        @Inject
        public synchronized void setHttpServerInfo(HttpServerInfo httpServerInfo) {
            this.httpServerInfo = httpServerInfo;
        }

        public synchronized ServiceAnnouncement get() {
            if (this.httpServerInfo.getAdminUri() != null) {
                URI adminUri = this.httpServerInfo.getAdminUri();
                if (adminUri.getScheme().equals("http")) {
                    this.builder.addProperty("http", adminUri.toString());
                    this.builder.addProperty("http-external", this.httpServerInfo.getAdminExternalUri().toString());
                } else if (adminUri.getScheme().equals("https")) {
                    this.builder.addProperty("https", adminUri.toString());
                }
            }
            return this.builder.build();
        }
    }

    static class CompositeDataSerializer
    extends StdSerializer<CompositeData> {
        CompositeDataSerializer() {
            super(CompositeData.class, true);
        }

        public void serialize(CompositeData data, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            Map map = JmxHttpModule.toMap(data);
            if (!map.isEmpty()) {
                jsonGenerator.writeStartObject();
                JsonSerializer cachedSerializer = null;
                Class<?> cachedType = null;
                for (Map.Entry entry : map.entrySet()) {
                    JsonSerializer serializer;
                    String key = (String)entry.getKey();
                    jsonGenerator.writeFieldName(key);
                    Object value = entry.getValue();
                    Class<?> valueType = value.getClass();
                    if (valueType == cachedType) {
                        serializer = cachedSerializer;
                    } else {
                        cachedSerializer = serializer = provider.findValueSerializer(valueType, null);
                        cachedType = valueType;
                    }
                    try {
                        serializer.serialize(value, jsonGenerator, provider);
                    }
                    catch (Exception e) {
                        this.wrapAndThrow(provider, e, map, key);
                    }
                }
                jsonGenerator.writeEndObject();
            } else {
                jsonGenerator.writeString("dain42");
            }
        }

        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            return this.createSchemaNode("object", true);
        }
    }

    static class TabularDataSerializer
    extends StdSerializer<TabularData> {
        TabularDataSerializer() {
            super(TabularData.class, true);
        }

        public void serialize(TabularData data, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeStartArray();
            JsonSerializer mapSerializer = provider.findValueSerializer(Map.class, null);
            for (Map map : JmxHttpModule.toList(data)) {
                if (map.isEmpty()) continue;
                mapSerializer.serialize((Object)map, jsonGenerator, provider);
            }
            jsonGenerator.writeEndArray();
        }

        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            o.set("items", (JsonNode)this.createSchemaNode("object", true));
            return o;
        }
    }
}

