/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jmx;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.proofpoint.jaxrs.AccessDoesNotRequireAuthentication;
import com.proofpoint.jmx.MBeanRepresentation;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/admin/jmx/mbean")
@AccessDoesNotRequireAuthentication
public class MBeanResource {
    private final MBeanServer mbeanServer;
    private final ObjectMapper objectMapper;

    @Inject
    public MBeanResource(MBeanServer mbeanServer, ObjectMapper objectMapper) {
        this.mbeanServer = mbeanServer;
        this.objectMapper = objectMapper;
    }

    @GET
    @Produces(value={"application/json"})
    public List<MBeanRepresentation> getMBeans() throws JMException {
        ImmutableList.Builder mbeans = ImmutableList.builder();
        for (ObjectName objectName : this.mbeanServer.queryNames(new ObjectName("*:*"), null)) {
            mbeans.add((Object)new MBeanRepresentation(this.mbeanServer, objectName, this.objectMapper));
        }
        return mbeans.build();
    }

    @GET
    @Path(value="{objectName}")
    @Produces(value={"application/json"})
    public MBeanRepresentation getMBean(@PathParam(value="objectName") ObjectName objectName) throws JMException {
        Objects.requireNonNull(objectName, "objectName is null");
        return new MBeanRepresentation(this.mbeanServer, objectName, this.objectMapper);
    }

    @GET
    @Path(value="{objectName}/{attributeName}")
    @Produces(value={"application/json"})
    public Object getMBean(@PathParam(value="objectName") ObjectName objectName, @PathParam(value="attributeName") String attributeName) throws JMException {
        Objects.requireNonNull(objectName, "objectName is null");
        return this.mbeanServer.getAttribute(objectName, attributeName);
    }
}

