/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.jmx;

import com.google.inject.Inject;
import com.proofpoint.discovery.client.announce.Announcer;
import com.proofpoint.jaxrs.AccessDoesNotRequireAuthentication;
import com.proofpoint.jmx.AdminServerCredentialVerifier;
import com.proofpoint.log.Logger;
import java.util.Objects;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;

@Path(value="/admin/stop-announcing")
@AccessDoesNotRequireAuthentication
public class StopAnnouncingResource {
    private static final Logger log = Logger.get(StopAnnouncingResource.class);
    private Announcer announcer;
    private final AdminServerCredentialVerifier adminServerCredentialVerifier;

    @Inject
    public StopAnnouncingResource(AdminServerCredentialVerifier adminServerCredentialVerifier) {
        this.adminServerCredentialVerifier = Objects.requireNonNull(adminServerCredentialVerifier, "adminServerCredentialVerifier is null");
    }

    @Inject(optional=true)
    public void setAnnouncer(Announcer announcer) {
        this.announcer = announcer;
    }

    @PUT
    public void stopAnnouncing(@Context SecurityContext securityContext, @HeaderParam(value="Authorization") String authHeader) {
        this.adminServerCredentialVerifier.authenticate(securityContext, authHeader);
        if (this.announcer != null) {
            log.info("Received shutdown request. Stopping discovery announcer.", new Object[0]);
            this.announcer.destroy();
        }
    }
}

