/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.proofpoint.reporting.ReportedAnnotation;
import com.proofpoint.reporting.Signature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Nested;

final class AnnotationUtils {
    private static final ImmutableSet<Class<? extends Annotation>> FLATTEN_OR_NESTED_ANNOTATION_SET = ImmutableSet.of(Nested.class, Flatten.class);
    private static final ImmutableSet<Class<? extends Annotation>> FLATTEN_ANNOTATION_SET = ImmutableSet.of(Flatten.class);
    private static final ImmutableSet<Class<? extends Annotation>> NESTED_ANNOTATION_SET = ImmutableSet.of(Nested.class);
    private static final ImmutableSet<Class<? extends Annotation>> REPORTED_ANNOTATION_SET = ImmutableSet.of(ReportedAnnotation.class);

    private AnnotationUtils() {
    }

    @SafeVarargs
    static Map<Method, Method> findAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> ... annotationClass) {
        HashMap<Method, Method> result = new HashMap<Method, Method>();
        HashSet<Signature> foundMethods = new HashSet<Signature>();
        AnnotationUtils.findAnnotatedMethods(clazz, result, foundMethods, (Set<Class<? extends Annotation>>)ImmutableSet.copyOf((Object[])annotationClass));
        return result;
    }

    private static void findAnnotatedMethods(Class<?> clazz, Map<Method, Method> result, Set<Signature> foundMethods, Set<Class<? extends Annotation>> annotationSet) {
        for (Method method : clazz.getDeclaredMethods()) {
            Signature methodSignature;
            if (method.isSynthetic() || method.isBridge() || foundMethods.contains(methodSignature = new Signature(method))) continue;
            foundMethods.add(methodSignature);
            Method reportedGetter = AnnotationUtils.findAnnotatedMethod(clazz, method.getName(), method.getParameterTypes(), annotationSet);
            if (reportedGetter == null) continue;
            method.setAccessible(true);
            reportedGetter.setAccessible(true);
            result.put(method, reportedGetter);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            AnnotationUtils.findAnnotatedMethods(superclass, result, foundMethods, annotationSet);
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            AnnotationUtils.findAnnotatedMethods(iface, result, foundMethods, annotationSet);
        }
    }

    private static Method findAnnotatedMethod(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Set<Class<? extends Annotation>> annotationSet) {
        Method reportedGetter;
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            if (AnnotationUtils.isAnnotatedMethod(method, annotationSet)) {
                return method;
            }
        }
        catch (NoSuchMethodException method) {
            // empty catch block
        }
        if (clazz.getSuperclass() != null && (reportedGetter = AnnotationUtils.findAnnotatedMethod(clazz.getSuperclass(), methodName, parameterTypes, annotationSet)) != null) {
            return reportedGetter;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            Method reportedGetter2 = AnnotationUtils.findAnnotatedMethod(iface, methodName, parameterTypes, annotationSet);
            if (reportedGetter2 == null) continue;
            return reportedGetter2;
        }
        return null;
    }

    @SafeVarargs
    static Collection<Field> findAnnotatedFields(Class<?> clazz, Class<? extends Annotation> ... annotationClass) {
        HashSet<Field> result = new HashSet<Field>();
        AnnotationUtils.findAnnotatedFields(clazz, result, (Set<Class<? extends Annotation>>)ImmutableSet.copyOf((Object[])annotationClass));
        return result;
    }

    private static void findAnnotatedFields(Class<?> clazz, Set<Field> result, Set<Class<? extends Annotation>> annotationSet) {
        for (Field field : clazz.getDeclaredFields()) {
            if (field.isSynthetic() || !AnnotationUtils.isAnnotationPresent(annotationSet, new HashSet<Class<? extends Annotation>>(), field.getDeclaredAnnotations())) continue;
            field.setAccessible(true);
            result.add(field);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            AnnotationUtils.findAnnotatedFields(superclass, result, annotationSet);
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            AnnotationUtils.findAnnotatedFields(iface, result, annotationSet);
        }
    }

    private static boolean isAnnotatedMethod(Method method, Set<Class<? extends Annotation>> annotationSet) {
        return AnnotationUtils.isAnnotationPresent((Set<Class<? extends Annotation>>)Sets.union(annotationSet, FLATTEN_OR_NESTED_ANNOTATION_SET), new HashSet<Class<? extends Annotation>>(), method.getAnnotations());
    }

    static boolean isFlatten(Method method) {
        return method != null && AnnotationUtils.isAnnotationPresent(FLATTEN_ANNOTATION_SET, new HashSet<Class<? extends Annotation>>(), method.getAnnotations());
    }

    static boolean isNested(Method method) {
        return method != null && AnnotationUtils.isAnnotationPresent(NESTED_ANNOTATION_SET, new HashSet<Class<? extends Annotation>>(), method.getAnnotations());
    }

    static boolean isReported(Method method) {
        return method != null && AnnotationUtils.isAnnotationPresent(REPORTED_ANNOTATION_SET, new HashSet<Class<? extends Annotation>>(), method.getAnnotations());
    }

    private static boolean isAnnotationPresent(Set<Class<? extends Annotation>> annotationClasses, Set<Class<? extends Annotation>> processedTypes, Annotation ... annotations) {
        for (Annotation annotation : annotations) {
            for (Class<? extends Annotation> annotationClass : annotationClasses) {
                if (!annotationClass.isInstance(annotation)) continue;
                return true;
            }
        }
        for (Annotation annotation : annotations) {
            if (!processedTypes.add(annotation.annotationType()) || !AnnotationUtils.isAnnotationPresent(annotationClasses, processedTypes, annotation.annotationType().getAnnotations())) continue;
            return true;
        }
        return false;
    }
}

