/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.proofpoint.reporting.AutoValue_Bucketed_BucketInfo;
import com.proofpoint.reporting.BucketIdProvider;
import javax.annotation.Nullable;

public abstract class Bucketed<T> {
    private static final BucketIdProvider INITIAL_BUCKET_ID_PROVIDER = () -> BucketIdProvider.BucketId.bucketId(-5, 0L);
    private BucketIdProvider bucketIdProvider = INITIAL_BUCKET_ID_PROVIDER;
    private BucketIdProvider.BucketId currentBucketId = BucketIdProvider.BucketId.bucketId(-10, 0L);
    private T previousBucket = null;
    private T currentBucket = null;

    protected abstract T createBucket(@Nullable T var1);

    protected final synchronized <R> R applyToCurrentBucket(Function<T, R> function) {
        this.rotateBucketIfNeeded();
        return (R)function.apply(this.currentBucket);
    }

    private synchronized BucketInfo getPreviousBucket() {
        this.rotateBucketIfNeeded();
        return BucketInfo.bucketInfo(this.previousBucket, this.currentBucketId);
    }

    @VisibleForTesting
    public synchronized void setBucketIdProvider(BucketIdProvider bucketIdProvider) {
        this.bucketIdProvider = bucketIdProvider;
        this.currentBucketId = bucketIdProvider.get();
        this.previousBucket = this.createBucket(null);
        this.currentBucket = this.createBucket(this.previousBucket);
    }

    private void rotateBucketIfNeeded() {
        BucketIdProvider.BucketId bucketId = this.bucketIdProvider.get();
        if (bucketId.getId() != this.currentBucketId.getId()) {
            this.previousBucket = this.currentBucketId.getId() + 1 == bucketId.getId() ? this.currentBucket : this.createBucket(this.currentBucket);
            this.currentBucketId = bucketId;
            this.currentBucket = this.createBucket(this.previousBucket);
        }
    }

    @AutoValue
    public static abstract class BucketInfo {
        static BucketInfo bucketInfo(Object bucket, BucketIdProvider.BucketId bucketId) {
            return new AutoValue_Bucketed_BucketInfo(bucket, bucketId);
        }

        public abstract Object getBucket();

        public abstract BucketIdProvider.BucketId getBucketId();
    }
}

