/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.inject.Injector;
import com.proofpoint.reporting.HealthExporter;
import com.proofpoint.reporting.HealthMapping;
import java.util.Set;
import javax.inject.Inject;
import javax.management.InstanceAlreadyExistsException;

class GuiceHealthExporter {
    private final HealthExporter healthExporter;

    @Inject
    GuiceHealthExporter(Set<HealthMapping> mappings, HealthExporter healthExporter, Injector injector) throws InstanceAlreadyExistsException {
        this.healthExporter = healthExporter;
        this.export(mappings, injector);
    }

    private void export(Set<HealthMapping> mappings, Injector injector) throws InstanceAlreadyExistsException {
        for (HealthMapping mapping : mappings) {
            Object object = injector.getInstance(mapping.getKey());
            this.healthExporter.export(mapping.getNameSuffix(), object);
        }
    }
}

